/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.dialogs.browser.MessageBoxCellRenderer;

public class DeleteOptionsDialog
extends DialogWrapper {
    private JTextArea myCommitMessage;
    private final Project myProject;

    public DeleteOptionsDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle("SVN Delete");
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.delete.options";
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        panel.add((Component)new JLabel("Commit Message:"), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.fill = 1;
        this.myCommitMessage = new JTextArea(10, 0);
        this.myCommitMessage.setWrapStyleWord(true);
        this.myCommitMessage.setLineWrap(true);
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessage), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 11;
        gc.fill = 2;
        panel.add((Component)new JLabel("Recent Messages: "), gc);
        ++gc.gridy;
        ArrayList messages = VcsConfiguration.getInstance((Project)this.myProject).getRecentMessages();
        Collections.reverse(messages);
        String[] model = ArrayUtil.toStringArray((Collection)messages);
        final JComboBox<String> messagesBox = new JComboBox<String>(model);
        messagesBox.setRenderer(new MessageBoxCellRenderer());
        panel.add(messagesBox, gc);
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        messagesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteOptionsDialog.this.myCommitMessage.setText(messagesBox.getSelectedItem().toString());
                DeleteOptionsDialog.this.myCommitMessage.selectAll();
            }
        });
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessage;
    }
}

