/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.util.NotNullFunction;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.browser.AbstractOpeningExpander;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;

public class UrlOpeningExpander
extends AbstractOpeningExpander {
    private final String myUrl;

    UrlOpeningExpander(RepositoryBrowserComponent browser, String selectionPath, String url) {
        super(browser, selectionPath);
        this.myUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    @Override
    protected AbstractOpeningExpander.ExpandVariants expandNode(String url) {
        if (this.myUrl.equals(url)) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_AND_EXIT;
        }
        if (this.myUrl.startsWith(url.endsWith("/") ? url : url + '/')) {
            return AbstractOpeningExpander.ExpandVariants.EXPAND_CONTINUE;
        }
        return AbstractOpeningExpander.ExpandVariants.DO_NOTHING;
    }

    @Override
    protected boolean checkChild(String childUrl) {
        return this.myUrl.startsWith(childUrl);
    }

    public static class Factory
    implements NotNullFunction<RepositoryBrowserComponent, Expander> {
        private final String myUrl;
        private final String mySelectionUrl;

        public Factory(String url, String selectionUrl) {
            this.myUrl = url;
            this.mySelectionUrl = selectionUrl;
        }

        public Expander fun(RepositoryBrowserComponent repositoryBrowserComponent) {
            return new UrlOpeningExpander(repositoryBrowserComponent, this.mySelectionUrl, this.myUrl);
        }
    }
}

