/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.diff;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepository;

public class DiffContentRevision
implements ContentRevision {
    private String myPath;
    private SVNRepository myRepository;
    private String myContents;
    private FilePath myFilePath;
    private long myRevision;

    public DiffContentRevision(String path, SVNRepository repos, long revision) {
        this(path, repos, revision, VcsUtil.getFilePath((String)path));
    }

    public DiffContentRevision(String path, SVNRepository repository, long revision, FilePath filePath) {
        this.myPath = path;
        this.myRepository = repository;
        this.myFilePath = filePath;
        this.myRevision = revision;
    }

    public String getContent() throws VcsException {
        if (this.myContents == null) {
            BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream(2048);
            try {
                this.myRepository.getFile(this.myPath, -1L, null, (OutputStream)bos);
                this.myRepository.closeSession();
            }
            catch (SVNException e) {
                throw new VcsException((Throwable)e);
            }
            byte[] bytes = bos.toByteArray();
            Charset charset = this.myFilePath.getCharset();
            this.myContents = CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
        }
        return this.myContents;
    }

    public FilePath getFile() {
        return this.myFilePath;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return new VcsRevisionNumber.Long(this.myRevision);
    }
}

