/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnPropertiesDiffViewer
extends TwosideTextDiffViewer {
    private final WrapperRequest myWrapperRequest;
    private final List<DiffChange> myDiffChanges;
    private boolean myFirstRediff = true;

    public static SvnPropertiesDiffViewer create(DiffContext context, SvnPropertiesDiffRequest request) {
        return SvnPropertiesDiffViewer.create(context, request, false);
    }

    public static SvnPropertiesDiffViewer create(DiffContext context, SvnPropertiesDiffRequest request, boolean embedded) {
        Pair<WrapperRequest, List<DiffChange>> pair = SvnPropertiesDiffViewer.convertRequest(request, embedded);
        return new SvnPropertiesDiffViewer(context, (WrapperRequest)((Object)pair.first), (List)pair.second);
    }

    private SvnPropertiesDiffViewer(DiffContext context, WrapperRequest request, List<DiffChange> diffChanges) {
        super(context, (ContentDiffRequest)request);
        this.myWrapperRequest = request;
        this.myDiffChanges = diffChanges;
        assert (this.myEditor1 != null && this.myEditor2 != null);
        for (EditorEx editor : this.getEditors()) {
            EditorSettings settings = editor.getSettings();
            settings.setAdditionalLinesCount(0);
            settings.setAdditionalColumnsCount(1);
            settings.setRightMarginShown(false);
            settings.setFoldingOutlineShown(false);
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setIndentGuidesShown(false);
            settings.setVirtualSpace(false);
            settings.setWheelFontChangeEnabled(false);
            settings.setAdditionalPageAtBottom(false);
            settings.setCaretRowShown(false);
            settings.setUseSoftWraps(false);
            editor.reinitSettings();
        }
        for (DiffChange change : this.myDiffChanges) {
            DiffDrawUtil.createBorderLineMarker((Editor)this.myEditor1, (int)change.myEndLine1, (SeparatorPlacement)SeparatorPlacement.TOP);
            DiffDrawUtil.createBorderLineMarker((Editor)this.myEditor2, (int)change.myEndLine2, (SeparatorPlacement)SeparatorPlacement.TOP);
        }
        DiffSplitter splitter = this.myContentPanel.getSplitter();
        assert (splitter != null);
        splitter.setDividerWidth(120);
        splitter.setShowDividerIcon(false);
    }

    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter((DiffSplitter.Painter)new MyDividerPainter());
    }

    protected boolean[] checkForceReadOnly() {
        return new boolean[]{true, true};
    }

    protected Runnable performRediff(ProgressIndicator indicator) {
        if (!this.myFirstRediff) {
            return new EmptyRunnable();
        }
        this.myFirstRediff = false;
        for (DiffChange change : this.myDiffChanges) {
            PropertyRecord record = change.getRecord();
            String before = record.getBefore();
            String after = record.getAfter();
            assert (before != null || after != null);
            if (before == null) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(0, after.length(), 0, StringUtil.countNewLines((CharSequence)after) + 1));
                continue;
            }
            if (after == null) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(before.length(), 0, StringUtil.countNewLines((CharSequence)before) + 1, 0));
                continue;
            }
            try {
                ComparisonManager manager = ComparisonManager.getInstance();
                change.setFragments(manager.squash(manager.compareLinesInner((CharSequence)before, (CharSequence)after, ComparisonPolicy.DEFAULT, indicator)));
            }
            catch (DiffTooBigException e) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(before.length(), after.length(), StringUtil.countNewLines((CharSequence)before) + 1, StringUtil.countNewLines((CharSequence)after) + 1));
            }
        }
        return new Runnable(){

            @Override
            public void run() {
                assert (SvnPropertiesDiffViewer.this.myEditor1 != null && SvnPropertiesDiffViewer.this.myEditor2 != null);
                for (DiffChange change : SvnPropertiesDiffViewer.this.myDiffChanges) {
                    SvnPropertiesDiffViewer.setupHighlighting(SvnPropertiesDiffViewer.this.myEditor1, change, Side.LEFT);
                    SvnPropertiesDiffViewer.setupHighlighting(SvnPropertiesDiffViewer.this.myEditor2, change, Side.RIGHT);
                }
            }
        };
    }

    private static void setupHighlighting(EditorEx editor, DiffChange change, Side side) {
        PropertyRecord record = change.getRecord();
        List<? extends LineFragment> fragments = change.getFragments();
        assert (fragments != null);
        DocumentEx document = editor.getDocument();
        int shift = document.getLineStartOffset(change.getStartLine(side));
        for (LineFragment lineFragment : fragments) {
            List innerFragments = lineFragment.getInnerFragments();
            int start = side.getStartOffset((DiffFragment)lineFragment) + shift;
            int end = side.getEndOffset((DiffFragment)lineFragment) + shift;
            TextDiffType type = DiffUtil.getLineDiffType((LineFragment)lineFragment);
            DiffDrawUtil.createHighlighter((Editor)editor, (int)start, (int)end, (TextDiffType)type, (innerFragments != null ? 1 : 0) != 0);
            if (innerFragments == null) continue;
            for (DiffFragment innerFragment : innerFragments) {
                int innerStart = side.getStartOffset(innerFragment);
                int innerEnd = side.getEndOffset(innerFragment);
                TextDiffType innerType = DiffUtil.getDiffType((DiffFragment)innerFragment);
                DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)(innerStart += start), (int)(innerEnd += start), (TextDiffType)innerType);
            }
        }
    }

    private static List<? extends LineFragment> createEverythingChanged(int length1, int length2, int lines1, int lines2) {
        return Collections.singletonList(new LineFragmentImpl(0, lines1, 0, lines2, 0, length1, 0, length2));
    }

    protected void onDocumentChange(DocumentEvent event) {
        LOG.warn("Document changes are not supported");
    }

    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        return new SyncScrollSupport.SyncScrollable(){

            public boolean isSyncScrollEnabled() {
                return true;
            }

            public int transfer(Side side, int line) {
                return line;
            }
        };
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "topicId758145";
        }
        return super.getData(dataId);
    }

    private static Pair<WrapperRequest, List<DiffChange>> convertRequest(SvnPropertiesDiffRequest request, boolean embedded) {
        List<PropertyRecord> records = SvnPropertiesDiffViewer.collectRecords(request);
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        ArrayList<DiffChange> diffChanges = new ArrayList<DiffChange>();
        int totalLines = 0;
        for (PropertyRecord record : records) {
            int i;
            int start = totalLines;
            String before = StringUtil.notNullize((String)record.getBefore());
            String after = StringUtil.notNullize((String)record.getAfter());
            builder1.append(before);
            builder2.append(after);
            int lines1 = StringUtil.countNewLines((CharSequence)before);
            int lines2 = StringUtil.countNewLines((CharSequence)after);
            int appendedLines = Math.max(lines1, lines2) + 1;
            totalLines += appendedLines;
            for (i = lines1; i < appendedLines; ++i) {
                builder1.append('\n');
            }
            for (i = lines2; i < appendedLines; ++i) {
                builder2.append('\n');
            }
            diffChanges.add(new DiffChange(record, start, totalLines, start, totalLines));
        }
        DocumentImpl document1 = new DocumentImpl((CharSequence)builder1);
        DocumentImpl document2 = new DocumentImpl((CharSequence)builder2);
        return Pair.create((Object)((Object)new WrapperRequest(request, (Document)document1, (Document)document2, embedded)), diffChanges);
    }

    private static List<PropertyRecord> collectRecords(SvnPropertiesDiffRequest request) {
        List<DiffContent> originalContents = request.getContents();
        List<PropertyData> properties1 = SvnPropertiesDiffViewer.getProperties(originalContents.get(0));
        List<PropertyData> properties2 = SvnPropertiesDiffViewer.getProperties(originalContents.get(1));
        HashMap before = new HashMap();
        HashMap after = new HashMap();
        if (properties1 != null) {
            for (PropertyData data : properties1) {
                before.put(data.getName(), data.getValue());
            }
        }
        if (properties2 != null) {
            for (PropertyData data : properties2) {
                after.put(data.getName(), data.getValue());
            }
        }
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>();
        for (String name : ContainerUtil.union(before.keySet(), after.keySet())) {
            records.add(SvnPropertiesDiffViewer.createRecord(name, (PropertyValue)before.get(name), (PropertyValue)after.get(name)));
        }
        ContainerUtil.sort(records, (Comparator)new Comparator<PropertyRecord>(){

            @Override
            public int compare(PropertyRecord o1, PropertyRecord o2) {
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            }
        });
        return records;
    }

    private static List<PropertyData> getProperties(DiffContent content) {
        if (content instanceof SvnPropertiesDiffRequest.PropertyContent) {
            return ((SvnPropertiesDiffRequest.PropertyContent)content).getProperties();
        }
        return null;
    }

    private static PropertyRecord createRecord(String name, PropertyValue value1, PropertyValue value2) {
        String text2;
        assert (value1 != null || value2 != null);
        String text1 = value1 != null ? value1.toString() : null;
        String string = text2 = value2 != null ? value2.toString() : null;
        if (text1 != null) {
            text1 = StringUtil.convertLineSeparators((String)text1);
        }
        if (text2 != null) {
            text2 = StringUtil.convertLineSeparators((String)text2);
        }
        return new PropertyRecord(name, text1, text2);
    }

    private static class DiffChange {
        private final PropertyRecord myRecord;
        private final int myStartLine1;
        private final int myEndLine1;
        private final int myStartLine2;
        private final int myEndLine2;
        private List<? extends LineFragment> myFragments;

        public DiffChange(PropertyRecord record, int startLine1, int endLine1, int startLine2, int endLine2) {
            this.myRecord = record;
            this.myStartLine1 = startLine1;
            this.myEndLine1 = endLine1;
            this.myStartLine2 = startLine2;
            this.myEndLine2 = endLine2;
        }

        public PropertyRecord getRecord() {
            return this.myRecord;
        }

        public int getStartLine(Side side) {
            return side.select(this.myStartLine1, this.myStartLine2);
        }

        public int getEndLine(Side side) {
            return side.select(this.myEndLine1, this.myEndLine2);
        }

        public void setFragments(List<? extends LineFragment> fragments) {
            this.myFragments = fragments;
        }

        public List<? extends LineFragment> getFragments() {
            return this.myFragments;
        }
    }

    private static class PropertyRecord {
        private final String myName;
        private final String myBefore;
        private final String myAfter;

        public PropertyRecord(String name, String before, String after) {
            assert (before != null || after != null);
            this.myName = name;
            this.myBefore = before;
            this.myAfter = after;
        }

        public String getName() {
            return this.myName;
        }

        public String getBefore() {
            return this.myBefore;
        }

        public String getAfter() {
            return this.myAfter;
        }
    }

    private static class WrapperRequest
    extends ContentDiffRequest {
        SvnPropertiesDiffRequest myRequest;
        DocumentContent myContent1;
        DocumentContent myContent2;
        private final boolean myEmbedded;

        public WrapperRequest(SvnPropertiesDiffRequest request, Document document1, Document document2, boolean embedded) {
            this.myRequest = request;
            this.myContent1 = DiffContentFactory.getInstance().create(null, document1);
            this.myContent2 = DiffContentFactory.getInstance().create(null, document2);
            this.myEmbedded = embedded;
        }

        public SvnPropertiesDiffRequest getPropertiesRequest() {
            return this.myRequest;
        }

        public List<DiffContent> getContents() {
            return ContainerUtil.list((Object[])new DiffContent[]{this.myContent1, this.myContent2});
        }

        public List<String> getContentTitles() {
            return this.myEmbedded ? ContainerUtil.list((Object[])new String[]{null, null}) : this.myRequest.getContentTitles();
        }

        public String getTitle() {
            return this.myRequest.getTitle();
        }

        public <T> T getUserData(Key<T> key) {
            return (T)this.myRequest.getUserData(key);
        }

        public <T> void putUserData(Key<T> key, T value) {
            this.myRequest.putUserData(key, value);
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private final JBLabel myLabel = new JBLabel();

        public MyDividerPainter() {
            this.myLabel.setFont(UIUtil.getLabelFont());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(1);
        }

        public void paint(Graphics g, JComponent divider) {
            assert (SvnPropertiesDiffViewer.this.myEditor1 != null && SvnPropertiesDiffViewer.this.myEditor2 != null);
            Graphics2D gg = SvnPropertiesDiffViewer.this.getDividerGraphics(g, divider);
            Rectangle clip = gg.getClipBounds();
            if (clip == null) {
                return;
            }
            gg.setColor(DiffDrawUtil.getDividerColor());
            gg.fill(clip);
            JComponent header1 = SvnPropertiesDiffViewer.this.myEditor1.getHeaderComponent();
            JComponent header2 = SvnPropertiesDiffViewer.this.myEditor2.getHeaderComponent();
            int headerOffset1 = header1 == null ? 0 : header1.getHeight();
            int headerOffset2 = header2 == null ? 0 : header2.getHeight();
            int shift1 = SvnPropertiesDiffViewer.this.myEditor1.getScrollingModel().getVerticalScrollOffset() - headerOffset1;
            int shift2 = SvnPropertiesDiffViewer.this.myEditor2.getScrollingModel().getVerticalScrollOffset() - headerOffset2;
            double rotate = shift1 == shift2 ? 0.0 : Math.atan2(shift2 - shift1, clip.width);
            DiffDividerDrawUtil.paintPolygons((Graphics2D)gg, (int)divider.getWidth(), (boolean)false, (rotate == 0.0 ? 1 : 0) != 0, (Editor)SvnPropertiesDiffViewer.this.myEditor1, (Editor)SvnPropertiesDiffViewer.this.myEditor2, (DiffDividerDrawUtil.DividerPaintable)this);
            for (DiffChange change : SvnPropertiesDiffViewer.this.myDiffChanges) {
                int y1 = ((SvnPropertiesDiffViewer)SvnPropertiesDiffViewer.this).myEditor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getStartLine((Side)Side.LEFT), (int)0)).y - shift1;
                int y2 = ((SvnPropertiesDiffViewer)SvnPropertiesDiffViewer.this).myEditor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getStartLine((Side)Side.RIGHT), (int)0)).y - shift2;
                int endY1 = ((SvnPropertiesDiffViewer)SvnPropertiesDiffViewer.this).myEditor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getEndLine((Side)Side.LEFT), (int)0)).y - shift1;
                int endY2 = ((SvnPropertiesDiffViewer)SvnPropertiesDiffViewer.this).myEditor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getEndLine((Side)Side.RIGHT), (int)0)).y - shift2;
                AffineTransform oldTransform = gg.getTransform();
                gg.translate(0, y1);
                if (rotate != 0.0) {
                    gg.rotate(-rotate);
                }
                this.myLabel.setText(change.getRecord().getName());
                this.myLabel.setForeground(this.getRecordTitleColor(change));
                this.myLabel.setBounds(clip);
                this.myLabel.paint((Graphics)gg);
                gg.setTransform(oldTransform);
                gg.setColor(JBColor.border());
                gg.drawLine(0, y1 - 1, clip.width, y2 - 1);
                gg.drawLine(0, endY1 - 1, clip.width, endY2 - 1);
            }
            gg.dispose();
        }

        public void process(DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            for (DiffChange diffChange : SvnPropertiesDiffViewer.this.myDiffChanges) {
                TextDiffType type = this.getDiffType(diffChange);
                if (type == null) continue;
                int shift1 = diffChange.getStartLine(Side.LEFT);
                int shift2 = diffChange.getStartLine(Side.RIGHT);
                List<? extends LineFragment> fragments = diffChange.getFragments();
                if (fragments == null) continue;
                for (LineFragment lineFragment : diffChange.getFragments()) {
                    if (handler.process(Side.LEFT.getStartLine(lineFragment) + shift1, Side.LEFT.getEndLine(lineFragment) + shift1, Side.RIGHT.getStartLine(lineFragment) + shift2, Side.RIGHT.getEndLine(lineFragment) + shift2, DiffUtil.getLineDiffType((LineFragment)lineFragment).getColor((Editor)SvnPropertiesDiffViewer.this.myEditor1))) continue;
                    return;
                }
            }
        }

        private Color getRecordTitleColor(DiffChange change) {
            TextDiffType type = this.getDiffType(change);
            if (type == TextDiffType.INSERTED) {
                return FileStatus.ADDED.getColor();
            }
            if (type == TextDiffType.DELETED) {
                return FileStatus.DELETED.getColor();
            }
            if (type == TextDiffType.MODIFIED) {
                return FileStatus.MODIFIED.getColor();
            }
            return JBColor.black;
        }

        public TextDiffType getDiffType(DiffChange change) {
            if (change.getRecord().getBefore() == null) {
                return TextDiffType.INSERTED;
            }
            if (change.getRecord().getAfter() == null) {
                return TextDiffType.DELETED;
            }
            if (change.getFragments() != null && !change.getFragments().isEmpty()) {
                return TextDiffType.MODIFIED;
            }
            return null;
        }
    }
}

