/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.ChangesBunch;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.idea.svn.history.BunchProvider;
import org.jetbrains.idea.svn.history.Fragment;
import org.jetbrains.idea.svn.history.Origin;
import org.jetbrains.idea.svn.history.SwitchRevisionsProviderException;

public abstract class CachedProvider
implements BunchProvider {
    private final Iterator<ChangesBunch> myIterator;
    private long myEarliestKeepedRevision;
    protected ChangesBunch myAlreadyReaded;
    protected Origin myOrigin;
    private boolean myHadBeenAccessed;

    protected CachedProvider(Iterator<ChangesBunch> iterator, Origin origin) {
        this.myIterator = iterator;
        this.myEarliestKeepedRevision = -1L;
        this.myAlreadyReaded = null;
        this.myOrigin = origin;
    }

    public abstract void doCacheUpdate(List<List<Fragment>> var1);

    protected static List<CommittedChangeList> getAllBeforeVisuallyCached(List<List<Fragment>> fragmentsListList) {
        ArrayList<CommittedChangeList> lists = new ArrayList<CommittedChangeList>();
        for (List<Fragment> fragmentList : fragmentsListList) {
            for (Fragment fragment : fragmentList) {
                if (Origin.VISUAL.equals((Object)fragment.getOrigin())) break;
                lists.addAll(fragment.getList());
            }
        }
        return lists;
    }

    @Override
    public long getEarliestRevision() {
        if (this.myEarliestKeepedRevision == -1L) {
            try {
                ChangesBunch changesBunch;
                while (this.myIterator.hasNext() && (changesBunch = this.myIterator.next()) != null) {
                    this.addToLoaded(changesBunch);
                    List list = this.myAlreadyReaded.getList();
                    if (list.isEmpty()) continue;
                    this.myEarliestKeepedRevision = ((CommittedChangeList)list.get(0)).getNumber();
                    break;
                }
            }
            catch (SwitchRevisionsProviderException e) {
                this.myEarliestKeepedRevision = -1L;
            }
        }
        return this.myEarliestKeepedRevision;
    }

    protected void addToLoaded(ChangesBunch loaded) {
        this.myAlreadyReaded = loaded;
    }

    @Override
    public Fragment getEarliestBunchInInterval(long earliestRevision, long oldestRevision, int desirableSize, boolean includeYoungest, boolean includeOldest) throws VcsException {
        if (earliestRevision > this.getEarliestRevision() || earliestRevision == -1L) {
            if (this.myAlreadyReaded == null) {
                return null;
            }
            return this.createFromLoaded(this.myAlreadyReaded, earliestRevision, oldestRevision, desirableSize, includeYoungest, includeOldest, false);
        }
        ChangesBunch loadedBunch = this.myAlreadyReaded;
        List list = loadedBunch.getList();
        if (list.isEmpty()) {
            return null;
        }
        long oldest = ((CommittedChangeList)list.get(list.size() - 1)).getNumber();
        if (!includeYoungest && oldest == earliestRevision) {
            return this.packNext(earliestRevision, oldestRevision, desirableSize, includeOldest, loadedBunch.isConsistentWithPrevious());
        }
        if (oldest <= earliestRevision) {
            return this.createFromLoaded(loadedBunch, earliestRevision, oldestRevision, desirableSize, includeYoungest, includeOldest, false);
        }
        return null;
    }

    private Fragment packNext(long earliestRevision, long oldestRevision, int desirableSize, boolean includeOldest, boolean wasConsistentWithPrevious) {
        try {
            if (this.myIterator.hasNext()) {
                ChangesBunch changesBunch = this.myIterator.next();
                if (changesBunch == null) {
                    return null;
                }
                this.addToLoaded(changesBunch);
                return this.createFromLoaded(changesBunch, earliestRevision, oldestRevision, desirableSize, true, includeOldest, wasConsistentWithPrevious);
            }
        }
        catch (SwitchRevisionsProviderException e) {
            // empty catch block
        }
        return null;
    }

    public boolean hadBeenSuccessfullyAccessed() {
        return this.myHadBeenAccessed;
    }

    private Fragment createFromLoaded(ChangesBunch loadedBunch, long earliestRevision, long oldestRevision, int desirableSize, boolean includeYoungest, boolean includeOldest, boolean consistent) {
        boolean consistentWithPrevious = loadedBunch.isConsistentWithPrevious();
        boolean consistentWithYounger = consistent;
        List list = loadedBunch.getList();
        ArrayList<CommittedChangeList> sublist = new ArrayList<CommittedChangeList>();
        for (int i = 0; i < list.size(); ++i) {
            CommittedChangeList changeList = (CommittedChangeList)list.get(i);
            if (!includeOldest && changeList.getNumber() == oldestRevision) continue;
            if (changeList.getNumber() == earliestRevision) {
                consistentWithYounger = true;
            }
            if (earliestRevision == -1L || changeList.getNumber() < earliestRevision || includeYoungest && changeList.getNumber() == earliestRevision) {
                sublist.add(changeList);
            }
            if (sublist.size() != desirableSize && changeList.getNumber() >= oldestRevision) continue;
            if (consistentWithPrevious) break;
            consistentWithPrevious = i > 0;
            break;
        }
        if (!this.myHadBeenAccessed) {
            this.myHadBeenAccessed = !sublist.isEmpty();
        }
        return sublist.isEmpty() ? null : new Fragment(this.myOrigin, sublist, consistentWithPrevious, consistentWithYounger, loadedBunch);
    }

    @Override
    public boolean isEmpty() {
        return this.getEarliestRevision() == -1L;
    }
}

