/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.util.containers.ContainerUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class LogEntry {
    public static final LogEntry EMPTY = new Builder().setRevision(-1L).setHasChildren(false).build();
    private final long myRevision;
    private final Date myDate;
    private final String myMessage;
    private final String myAuthor;
    private final Map<String, LogEntryPath> myChangedPaths;
    private boolean myHasChildren;

    public static LogEntry create(SVNLogEntry entry) {
        LogEntry result = null;
        if (entry != null) {
            Builder builder = new Builder();
            if (entry.getChangedPaths() != null) {
                for (SVNLogEntryPath path : entry.getChangedPaths().values()) {
                    builder.addPath(LogEntryPath.create(path));
                }
            }
            result = builder.setRevision(entry.getRevision()).setAuthor(entry.getAuthor()).setDate(entry.getDate()).setMessage(entry.getMessage()).setHasChildren(entry.hasChildren()).build();
        }
        return result;
    }

    public LogEntry(Builder builder) {
        this.myRevision = builder.revision;
        this.myChangedPaths = LogEntry.toImmutable(builder.changedPaths);
        this.myAuthor = builder.author;
        this.myDate = builder.date;
        this.myMessage = builder.message;
        this.myHasChildren = builder.hasChildren();
    }

    private static Map<String, LogEntryPath> toImmutable(List<LogEntryPath.Builder> paths) {
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        for (LogEntryPath.Builder path : paths) {
            builder.put((Object)path.getPath(), (Object)path.build());
        }
        return builder.build();
    }

    public Map<String, LogEntryPath> getChangedPaths() {
        return this.myChangedPaths;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public boolean hasChildren() {
        return this.myHasChildren;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentry")
    public static class Builder {
        @XmlAttribute(name="revision")
        private long revision;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;
        @XmlElement(name="msg")
        private String message;
        @XmlElementWrapper(name="paths")
        @XmlElement(name="path")
        private List<LogEntryPath.Builder> changedPaths = ContainerUtil.newArrayList();
        @XmlElement(name="logentry")
        private List<Builder> childEntries = ContainerUtil.newArrayList();

        public List<Builder> getChildEntries() {
            return this.childEntries;
        }

        public boolean hasChildren() {
            return !this.childEntries.isEmpty();
        }

        public Builder setRevision(long revision) {
            this.revision = revision;
            return this;
        }

        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setHasChildren(boolean hasChildren) {
            this.childEntries.clear();
            if (hasChildren) {
                this.childEntries.add(this);
            }
            return this;
        }

        public Builder addPath(LogEntryPath.Builder path) {
            this.changedPaths.add(path);
            return this;
        }

        public LogEntry build() {
            return new LogEntry(this);
        }
    }
}

