/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.tmatesoft.svn.core.SVNLogEntryPath;

public class LogEntryPath
extends BaseNodeDescription {
    private final String myPath;
    private final char myType;
    private final String myCopyPath;
    private final long myCopyRevision;

    public static Builder create(SVNLogEntryPath path) {
        return new Builder().setPath(path.getPath()).setType(path.getType()).setCopyFromPath(path.getCopyPath()).setCopyFromRevision(path.getCopyRevision()).setKind(NodeKind.from(path.getKind()));
    }

    public LogEntryPath(Builder builder) {
        super(builder.kind);
        this.myPath = builder.path;
        this.myType = CommandUtil.getStatusChar(builder.action);
        this.myCopyPath = builder.copyFromPath;
        this.myCopyRevision = builder.copyFromRevision;
    }

    public String getCopyPath() {
        return this.myCopyPath;
    }

    public long getCopyRevision() {
        return this.myCopyRevision;
    }

    public String getPath() {
        return this.myPath;
    }

    public char getType() {
        return this.myType;
    }

    public NodeKind getKind() {
        return this.myKind;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="logentrypath")
    public static class Builder {
        @XmlAttribute(name="kind", required=true)
        private NodeKind kind;
        @XmlAttribute(name="action")
        private String action;
        @XmlAttribute(name="copyfrom-path")
        private String copyFromPath;
        @XmlAttribute(name="copyfrom-rev")
        private long copyFromRevision;
        @XmlValue
        private String path;

        public String getPath() {
            return this.path;
        }

        public Builder setKind(NodeKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder setType(char type) {
            this.action = String.valueOf(type);
            return this;
        }

        public Builder setCopyFromPath(String copyFromPath) {
            this.copyFromPath = copyFromPath;
            return this;
        }

        public Builder setCopyFromRevision(long copyFromRevision) {
            this.copyFromRevision = copyFromRevision;
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public LogEntryPath build() {
            return new LogEntryPath(this);
        }
    }
}

