/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import java.io.File;
import java.util.List;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.history.SvnFileRevision;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<SvnFileRevision> {
    private final SvnVcs myVcs;

    public SvnDiffFromHistoryHandler(SvnVcs vcs) {
        super(vcs.getProject());
        this.myVcs = vcs;
    }

    protected List<Change> getChangesBetweenRevisions(FilePath path, SvnFileRevision rev1, SvnFileRevision rev2) throws VcsException {
        File file = path.getIOFile();
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev1.getURL()), (SVNRevision)rev1.getRevision());
        SvnTarget target2 = rev2 != null ? SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev2.getURL()), (SVNRevision)rev2.getRevision()) : SvnTarget.fromFile((File)file);
        return this.executeDiff(path, target1, target2);
    }

    protected List<Change> getAffectedChanges(FilePath path, SvnFileRevision rev) throws VcsException {
        SvnTarget target1 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev.getURL()), (SVNRevision)SVNRevision.create((long)0L));
        SvnTarget target2 = SvnTarget.fromURL((SVNURL)SvnUtil.createUrl(rev.getURL()), (SVNRevision)rev.getRevision());
        return this.executeDiff(path, target1, target2);
    }

    protected String getPresentableName(SvnFileRevision revision) {
        return revision.getRevisionNumber().asString();
    }

    private List<Change> executeDiff(FilePath path, SvnTarget target1, SvnTarget target2) throws VcsException {
        File file = path.getIOFile();
        ClientFactory factory = target2.isURL() ? this.myVcs.getFactory(file) : DirectoryWithBranchComparer.getClientFactory(this.myVcs, file);
        return factory.createDiffClient().compare(target1, target2);
    }
}

