/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.util.NotNullFunction;
import java.io.File;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnRepositoryLocation
implements RepositoryLocation {
    private final String myURL;
    private final FilePath myRoot;

    public SvnRepositoryLocation(String url) {
        this(url, null);
    }

    public SvnRepositoryLocation(String url, FilePath root) {
        this.myURL = url;
        this.myRoot = root;
    }

    public String toString() {
        return this.myURL;
    }

    public String toPresentableString() {
        return this.myURL;
    }

    public String getURL() {
        return this.myURL;
    }

    public String getKey() {
        return this.myURL;
    }

    public FilePath getRoot() {
        return this.myRoot;
    }

    public void onBeforeBatch() throws VcsException {
    }

    public void onAfterBatch() {
    }

    public static FilePath getLocalPath(String fullPath, NotNullFunction<File, Boolean> detector, SvnVcs vcs) {
        if (vcs.getProject().isDefault()) {
            return null;
        }
        RootUrlInfo rootForUrl = vcs.getSvnFileUrlMapping().getWcRootForUrl(fullPath);
        FilePath result = null;
        if (rootForUrl != null) {
            String relativePath = SvnUtil.getRelativeUrl(rootForUrl.getUrl(), fullPath);
            File file = new File(rootForUrl.getPath(), relativePath);
            result = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file, detector);
        }
        return result;
    }

    public SVNURL toSvnUrl() throws SvnBindException {
        return SvnUtil.createUrl(this.myURL);
    }
}

