/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.info;

import java.io.File;
import java.util.Date;
import org.jetbrains.idea.svn.api.BaseNodeDescription;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.NodeKind;
import org.jetbrains.idea.svn.conflict.TreeConflictDescription;
import org.jetbrains.idea.svn.lock.Lock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class Info
extends BaseNodeDescription {
    public static final String SCHEDULE_ADD = "add";
    private final File myFile;
    private final String myPath;
    private final SVNURL myURL;
    private final SVNRevision myRevision;
    private final SVNURL myRepositoryRootURL;
    private final String myRepositoryUUID;
    private final SVNRevision myCommittedRevision;
    private final Date myCommittedDate;
    private final String myAuthor;
    private final Lock myLock;
    private final boolean myIsRemote;
    private final String mySchedule;
    private final SVNURL myCopyFromURL;
    private final SVNRevision myCopyFromRevision;
    private final File myConflictOldFile;
    private final File myConflictNewFile;
    private final File myConflictWrkFile;
    private final File myPropConflictFile;
    private final Depth myDepth;
    private final TreeConflictDescription myTreeConflict;

    public static Info create(SVNInfo info) {
        Info result = info.isRemote() ? new Info(info.getPath(), info.getURL(), info.getRevision(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getRepositoryRootURL(), info.getCommittedRevision().getNumber(), info.getCommittedDate(), info.getAuthor(), Lock.create(info.getLock()), Depth.from(info.getDepth())) : new Info(info.getFile(), info.getURL(), info.getRepositoryRootURL(), info.getRevision().getNumber(), NodeKind.from(info.getKind()), info.getRepositoryUUID(), info.getCommittedRevision().getNumber(), Info.toString(info.getCommittedDate()), info.getAuthor(), info.getSchedule(), info.getCopyFromURL(), info.getCopyFromRevision().getNumber(), Info.getName(info.getConflictOldFile()), Info.getName(info.getConflictNewFile()), Info.getName(info.getConflictWrkFile()), Info.getName(info.getPropConflictFile()), Lock.create(info.getLock()), Depth.from(info.getDepth()), TreeConflictDescription.create(info.getTreeConflict()));
        return result;
    }

    public Info(File file, SVNURL url, SVNURL rootURL, long revision, NodeKind kind, String uuid, long committedRevision, String committedDate, String author, String schedule, SVNURL copyFromURL, long copyFromRevision, String conflictOldFileName, String conflictNewFileName, String conflictWorkingFileName, String propRejectFileName, Lock lock, Depth depth, TreeConflictDescription treeConflict) {
        super(kind);
        this.myFile = file;
        this.myURL = url;
        this.myRevision = SVNRevision.create((long)revision);
        this.myRepositoryUUID = uuid;
        this.myRepositoryRootURL = rootURL;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myCommittedDate = committedDate != null ? SVNDate.parseDate((String)committedDate) : null;
        this.myAuthor = author;
        this.mySchedule = schedule;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = SVNRevision.create((long)copyFromRevision);
        this.myLock = lock;
        this.myTreeConflict = treeConflict;
        this.myConflictOldFile = Info.resolveConflictFile(file, conflictOldFileName);
        this.myConflictNewFile = Info.resolveConflictFile(file, conflictNewFileName);
        this.myConflictWrkFile = Info.resolveConflictFile(file, conflictWorkingFileName);
        this.myPropConflictFile = Info.resolveConflictFile(file, propRejectFileName);
        this.myIsRemote = false;
        this.myDepth = depth;
        this.myPath = null;
    }

    public Info(String path, SVNURL url, SVNRevision revision, NodeKind kind, String uuid, SVNURL reposRootURL, long committedRevision, Date date, String author, Lock lock, Depth depth) {
        super(kind);
        this.myIsRemote = true;
        this.myURL = url;
        this.myRevision = revision;
        this.myRepositoryRootURL = reposRootURL;
        this.myRepositoryUUID = uuid;
        this.myCommittedDate = date;
        this.myCommittedRevision = SVNRevision.create((long)committedRevision);
        this.myAuthor = author;
        this.myLock = lock;
        this.myPath = path;
        this.myDepth = depth;
        this.myFile = null;
        this.mySchedule = null;
        this.myCopyFromURL = null;
        this.myCopyFromRevision = null;
        this.myConflictOldFile = null;
        this.myConflictNewFile = null;
        this.myConflictWrkFile = null;
        this.myPropConflictFile = null;
        this.myTreeConflict = null;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public TreeConflictDescription getTreeConflict() {
        return this.myTreeConflict;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    public NodeKind getKind() {
        return this.myKind;
    }

    public Lock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public Depth getDepth() {
        return this.myDepth;
    }

    private static File resolveConflictFile(File file, String path) {
        return file != null && path != null ? new File(file.getParentFile(), path) : null;
    }

    private static String getName(File file) {
        return file != null ? file.getName() : null;
    }

    private static String toString(Date date) {
        return date != null ? date.toString() : null;
    }
}

