/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.TransparentlyFailedValueI;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.BranchMerger;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.MergeTask;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;

public class MergeAllWithBranchCopyPointTask
extends BaseMergeTask
implements Consumer<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> {
    private final AtomicReference<TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException>> myData = new AtomicReference();

    public MergeAllWithBranchCopyPointTask(MergeContext mergeContext, QuickMergeInteraction interaction) {
        super(mergeContext, interaction, "merge all", Where.AWT);
    }

    public void consume(TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException> value) {
        this.myData.set(value);
    }

    public void run(ContinuationContext context) {
        TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException> inverterValue = this.myData.get();
        if (inverterValue != null) {
            this.runMerge(context, inverterValue);
        } else {
            this.finishWithError(context, "Merge start wasn't found", true);
        }
    }

    private void runMerge(ContinuationContext context, TransparentlyFailedValueI<SvnBranchPointsCalculator.WrapperInvertor, VcsException> inverterValue) {
        try {
            SvnBranchPointsCalculator.WrapperInvertor inverter = (SvnBranchPointsCalculator.WrapperInvertor)inverterValue.get();
            if (inverter != null) {
                this.runMerge(context, inverter);
            } else {
                this.finishWithError(context, "Merge start wasn't found", true);
            }
        }
        catch (VcsException e) {
            this.finishWithError(context, "Merge start wasn't found", Collections.singletonList(e));
        }
    }

    private void runMerge(ContinuationContext context, SvnBranchPointsCalculator.WrapperInvertor inverter) {
        boolean reintegrate = inverter.isInvertedSense();
        if (reintegrate && !this.myInteraction.shouldReintegrate(this.myMergeContext.getSourceUrl(), inverter.inverted().getTarget())) {
            context.cancelEverything();
        } else {
            MergerFactory mergerFactory = this.createBranchMergerFactory(reintegrate, inverter);
            String title = "Merging all from " + this.myMergeContext.getBranchName() + (reintegrate ? " (reintegrate)" : "");
            context.next(new TaskDescriptor[]{new MergeTask(this.myMergeContext, this.myInteraction, mergerFactory, title)});
        }
    }

    private MergerFactory createBranchMergerFactory(final boolean reintegrate, final SvnBranchPointsCalculator.WrapperInvertor inverter) {
        return new MergerFactory(){

            @Override
            public IMerger createMerger(SvnVcs vcs, File target, UpdateEventHandler handler, SVNURL currentBranchUrl, String branchName) {
                return new BranchMerger(vcs, currentBranchUrl, MergeAllWithBranchCopyPointTask.this.myMergeContext.getWcInfo().getPath(), handler, reintegrate, MergeAllWithBranchCopyPointTask.this.myMergeContext.getBranchName(), reintegrate ? inverter.getWrapped().getTargetRevision() : inverter.getWrapped().getSourceRevision());
            }
        };
    }
}

