/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class MergeContext {
    private final Project myProject;
    private final String myBranchName;
    private final VirtualFile myRoot;
    private final WCInfo myWcInfo;
    private final String mySourceUrl;
    private final SvnVcs myVcs;
    private final String myTitle;
    private final String myRepositoryRelativeSourcePath;

    public MergeContext(SvnVcs vcs, String sourceUrl, WCInfo wcInfo, String branchName, VirtualFile root) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myBranchName = branchName;
        this.myRoot = root;
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(SVNPathUtil.getRelativePath((String)this.myWcInfo.getRepositoryRoot(), (String)this.mySourceUrl));
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getBranchName() {
        return this.myBranchName;
    }

    public VirtualFile getRoot() {
        return this.myRoot;
    }

    public WCInfo getWcInfo() {
        return this.myWcInfo;
    }

    public String getSourceUrl() {
        return this.mySourceUrl;
    }

    public String getRepositoryRelativeSourcePath() {
        return this.myRepositoryRelativeSourcePath;
    }

    public SvnVcs getVcs() {
        return this.myVcs;
    }

    public String getTitle() {
        return this.myTitle;
    }
}

