/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.Where;
import java.io.File;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;

public class MergeInitChecksTask
extends BaseMergeTask {
    public MergeInitChecksTask(MergeContext mergeContext, QuickMergeInteraction interaction) {
        super(mergeContext, interaction, "initial checks", Where.AWT);
    }

    public void run(ContinuationContext context) {
        SVNURL url = this.parseSourceUrl(context);
        if (url != null) {
            if (MergeInitChecksTask.areInSameHierarchy(url, this.myMergeContext.getWcInfo().getUrl())) {
                this.finishWithError(context, "Cannot merge from self", true);
            } else if (this.hasSwitchedRoots() && !this.myInteraction.shouldContinueSwitchedRootFound()) {
                context.cancelEverything();
            }
        }
    }

    private boolean hasSwitchedRoots() {
        final File currentRoot = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        return ContainerUtil.or(this.myMergeContext.getVcs().getAllWcInfos(), (Condition)new Condition<WCInfo>(){

            public boolean value(WCInfo info) {
                return NestedCopyType.switched.equals((Object)info.getType()) && FileUtil.isAncestor((File)currentRoot, (File)info.getRootInfo().getIoFile(), (boolean)true);
            }
        });
    }

    private static boolean areInSameHierarchy(SVNURL url1, SVNURL url2) {
        return SVNURLUtil.isAncestor((SVNURL)url1, (SVNURL)url2) || SVNURLUtil.isAncestor((SVNURL)url2, (SVNURL)url1);
    }
}

