/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.continuation.Continuation;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.Collections;
import java.util.List;
import org.jetbrains.idea.svn.dialogs.MergeDialogI;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.LoadRecentBranchRevisions;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMergeInteraction;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;

public class ShowRecentInDialogTask
extends BaseMergeTask {
    private final LoadRecentBranchRevisions myInitialChangeListsLoader;

    public ShowRecentInDialogTask(MergeContext mergeContext, QuickMergeInteraction interaction, LoadRecentBranchRevisions initialChangeListsLoader) {
        super(mergeContext, interaction, "", Where.AWT);
        this.myInitialChangeListsLoader = initialChangeListsLoader;
    }

    public void run(ContinuationContext context) {
        List<CommittedChangeList> lists = this.myInteraction.showRecentListsForSelection(this.myInitialChangeListsLoader.getCommittedChangeLists(), this.myMergeContext.getTitle(), this.myInitialChangeListsLoader.getHelper(), this.createMoreChangeListsLoader(), this.myInitialChangeListsLoader.isLastLoaded());
        if (lists != null && !lists.isEmpty()) {
            this.runChangeListsMerge(context, lists, this.createBranchCopyPoint(), this.myMergeContext.getTitle());
        } else {
            context.cancelEverything();
        }
    }

    private PairConsumer<Long, MergeDialogI> createMoreChangeListsLoader() {
        return new PairConsumer<Long, MergeDialogI>(){

            public void consume(Long bunchSize, MergeDialogI dialog) {
                LoadRecentBranchRevisions loader = new LoadRecentBranchRevisions(ShowRecentInDialogTask.this.myMergeContext, dialog.getLastNumber(), bunchSize.intValue());
                TaskDescriptor updater = ShowRecentInDialogTask.createUpdateDialogTask(dialog, loader);
                Continuation fragmented = Continuation.createFragmented((Project)ShowRecentInDialogTask.this.myMergeContext.getProject(), (boolean)true);
                fragmented.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

                    public void consume(VcsException e) {
                        PopupUtil.showBalloonForActiveComponent((String)(e.getMessage() == null ? ((Object)((Object)e)).getClass().getName() : e.getMessage()), (MessageType)MessageType.ERROR);
                    }
                });
                fragmented.run(new TaskDescriptor[]{loader, updater});
            }
        };
    }

    private SvnBranchPointsCalculator.WrapperInvertor createBranchCopyPoint() {
        return new SvnBranchPointsCalculator.WrapperInvertor(false, new SvnBranchPointsCalculator.BranchCopyData(this.myMergeContext.getWcInfo().getUrl().toString(), -1L, this.myMergeContext.getSourceUrl(), -1L));
    }

    private static TaskDescriptor createUpdateDialogTask(final MergeDialogI dialog, final LoadRecentBranchRevisions loader) {
        return new TaskDescriptor("", Where.AWT){

            public void run(ContinuationContext context) {
                dialog.addMoreLists(loader.getCommittedChangeLists());
                if (loader.isLastLoaded()) {
                    dialog.setEverythingLoaded(true);
                }
            }

            public void canceled() {
                dialog.addMoreLists(Collections.<CommittedChangeList>emptyList());
                dialog.setEverythingLoaded(true);
            }
        };
    }
}

