/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.integrate.AlienDirtyScope;
import org.jetbrains.idea.svn.integrate.GatheringChangelistBuilder;
import org.jetbrains.idea.svn.integrate.IMerger;
import org.jetbrains.idea.svn.integrate.IntegrateEventHandler;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.ResolveWorker;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.update.UpdateEventHandler;
import org.tmatesoft.svn.core.SVNURL;

public class SvnIntegrateChangesTask
extends Task.Backgroundable {
    private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
    private final SvnVcs myVcs;
    private final WorkingCopyInfo myInfo;
    private final UpdatedFilesReverseSide myAccumulatedFiles;
    private UpdatedFiles myRecentlyUpdatedFiles;
    private final List<VcsException> myExceptions;
    private UpdateEventHandler myHandler;
    private IMerger myMerger;
    private ResolveWorker myResolveWorker;
    private FilePathImpl myMergeTarget;
    private final String myTitle;
    private boolean myDryRun;

    public SvnIntegrateChangesTask(SvnVcs vcs, WorkingCopyInfo info, MergerFactory mergerFactory, SVNURL currentBranchUrl, String title, boolean dryRun, String branchName) {
        super(vcs.getProject(), title, true, VcsConfiguration.getInstance((Project)vcs.getProject()).getUpdateOption());
        this.myDryRun = dryRun;
        this.myTitle = title;
        this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx((Project)this.myProject);
        this.myVcs = vcs;
        this.myInfo = info;
        this.myAccumulatedFiles = new UpdatedFilesReverseSide(UpdatedFiles.create());
        this.myExceptions = new ArrayList<VcsException>();
        this.myHandler = new IntegrateEventHandler(this.myVcs, ProgressManager.getInstance().getProgressIndicator());
        this.myMerger = mergerFactory.createMerger(this.myVcs, new File(this.myInfo.getLocalPath()), this.myHandler, currentBranchUrl, branchName);
    }

    private static void indicatorOnStart() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setIndeterminate(true);
            indicator.setText(SvnBundle.message("action.Subversion.integrate.changes.progress.integrating.text", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ProgressIndicator indicator) {
        this.myHandler.setProgressIndicator(ProgressManager.getInstance().getProgressIndicator());
        this.myResolveWorker = new ResolveWorker(this.myInfo.isUnderProjectRoot(), this.myProject);
        ProjectManagerEx.getInstanceEx().blockReloadingProjectOnExternalChanges();
        this.myProjectLevelVcsManager.startBackgroundVcsOperation();
        try {
            this.myRecentlyUpdatedFiles = UpdatedFiles.create();
            this.myHandler.setUpdatedFiles(this.myRecentlyUpdatedFiles);
            SvnIntegrateChangesTask.indicatorOnStart();
            while (true) {
                this.doMerge();
                RefreshVFsSynchronously.updateAllChanged((UpdatedFiles)this.myRecentlyUpdatedFiles);
                indicator.setText(VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
                if (this.myResolveWorker.needsInteraction(this.myRecentlyUpdatedFiles) || !this.myMerger.hasNext() || !this.myExceptions.isEmpty()) break;
                if (UpdatedFilesReverseSide.containErrors((UpdatedFiles)this.myRecentlyUpdatedFiles)) {
                    break;
                }
                this.accumulate();
            }
        }
        finally {
            this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
        }
    }

    private static VcsException createError(String ... messages) {
        return SvnIntegrateChangesTask.createException(false, messages);
    }

    private static VcsException createWarning(String ... messages) {
        return SvnIntegrateChangesTask.createException(true, messages);
    }

    private static VcsException createException(boolean isWarning, String ... messages) {
        List notEmptyMessages = ContainerUtil.mapNotNull((Object[])messages, (Function)new Function<String, String>(){

            public String fun(String message) {
                return StringUtil.nullize((String)message, (boolean)true);
            }
        });
        return new VcsException((Collection)notEmptyMessages).setIsWarning(isWarning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMerge() {
        this.myHandler.startUpdate();
        try {
            this.myMerger.mergeNext();
        }
        catch (VcsException e) {
            this.myExceptions.add(SvnIntegrateChangesTask.createError(e.getMessage(), this.myMerger.getInfo(), this.myMerger.getSkipped()));
        }
        finally {
            this.myHandler.finishUpdate();
        }
    }

    public void onCancel() {
        this.onTaskFinished(true);
    }

    public void onSuccess() {
        this.onTaskFinished(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTaskFinished(boolean wasCancelled) {
        try {
            if (!this.myProject.isDisposed()) {
                this.afterExecution(wasCancelled);
            }
        }
        finally {
            ProjectManagerEx.getInstanceEx().unblockReloadingProjectOnExternalChanges();
        }
    }

    private void accumulate() {
        this.myAccumulatedFiles.accomulateFiles(this.myRecentlyUpdatedFiles, UpdatedFilesReverseSide.DuplicateLevel.DUPLICATE_ERRORS);
    }

    private void afterExecution(boolean wasCanceled) {
        if (!this.myRecentlyUpdatedFiles.isEmpty()) {
            this.myResolveWorker.execute(this.myRecentlyUpdatedFiles);
        }
        boolean haveConflicts = ResolveWorker.haveUnresolvedConflicts(this.myRecentlyUpdatedFiles);
        this.accumulate();
        if (!this.myMerger.hasNext() || haveConflicts || !this.myExceptions.isEmpty() || this.myAccumulatedFiles.containErrors() || wasCanceled) {
            this.initMergeTarget();
            if (this.myAccumulatedFiles.isEmpty() && this.myExceptions.isEmpty() && this.myMergeTarget == null && !wasCanceled) {
                Messages.showMessageDialog((String)SvnBundle.message("action.Subversion.integrate.changes.message.files.up.to.date.text", new Object[0]), (String)this.myTitle, (Icon)Messages.getInformationIcon());
            } else {
                if (haveConflicts) {
                    this.myExceptions.add(SvnIntegrateChangesTask.createWarning(SvnBundle.message("svn.integrate.changelist.warning.unresolved.conflicts.text", new Object[0])));
                }
                if (wasCanceled) {
                    this.myExceptions.add(SvnIntegrateChangesTask.createWarning("Integration was canceled", this.myMerger.getSkipped()));
                }
                this.finishActions(wasCanceled);
            }
            this.myMerger.afterProcessing();
        } else {
            this.stepToNextChangeList();
        }
    }

    private void finishActions(boolean wasCanceled) {
        if (!(wasCanceled || ApplicationManager.getApplication().isUnitTestMode() || this.myDryRun || !this.myExceptions.isEmpty() || this.myAccumulatedFiles.containErrors() || this.myAccumulatedFiles.isEmpty() && this.myMergeTarget == null)) {
            if (this.myInfo.isUnderProjectRoot()) {
                this.showLocalCommit();
            } else {
                this.showAlienCommit();
            }
            return;
        }
        Collection<FilePath> files = this.gatherChangedPaths();
        VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty(files, null);
        this.prepareAndShowResults();
    }

    private void prepareAndShowResults() {
        if (!this.myAccumulatedFiles.isEmpty()) {
            this.showUpdateTree();
        }
        if (!this.myExceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myExceptions.size()}));
        }
    }

    private void showUpdateTree() {
        RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance((Project)this.myProject);
        restoreUpdateTree.registerUpdateInformation(this.myAccumulatedFiles.getUpdatedFiles(), ActionInfo.INTEGRATE);
        this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myAccumulatedFiles.getUpdatedFiles(), this.myTitle, ActionInfo.INTEGRATE, false);
    }

    private void stepToNextChangeList() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().run((Task)SvnIntegrateChangesTask.this);
            }
        });
    }

    private void initMergeTarget() {
        Status svnStatus;
        File mergeInfoHolder = this.myMerger.getMergeInfoHolder();
        if (mergeInfoHolder != null && (svnStatus = SvnUtil.getStatus(this.myVcs, mergeInfoHolder)) != null && svnStatus.isProperty(StatusType.STATUS_MODIFIED)) {
            this.myMergeTarget = FilePathImpl.create((File)mergeInfoHolder, (boolean)mergeInfoHolder.isDirectory());
        }
    }

    private void showLocalCommit() {
        final Collection<FilePath> files = this.gatherChangedPaths();
        final ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        changeListManager.invokeAfterUpdate(new Runnable(){

            @Override
            public void run() {
                ArrayList changes = new ArrayList();
                for (FilePath file : files) {
                    ContainerUtil.addIfNotNull(changes, (Object)changeListManager.getChange(file));
                }
                CommitChangeListDialog.commitChanges((Project)SvnIntegrateChangesTask.this.myProject, changes, null, null, (String)SvnIntegrateChangesTask.this.myMerger.getComment());
                SvnIntegrateChangesTask.this.prepareAndShowResults();
            }
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, this.myTitle, (Consumer)new Consumer<VcsDirtyScopeManager>(){

            public void consume(VcsDirtyScopeManager vcsDirtyScopeManager) {
                vcsDirtyScopeManager.filePathsDirty(files, null);
            }
        }, null);
    }

    private Collection<FilePath> gatherChangedPaths() {
        final ArrayList<FilePath> result = new ArrayList<FilePath>();
        UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccumulatedFiles.getUpdatedFiles(), (UpdateFilesHelper.Callback)new UpdateFilesHelper.Callback(){

            public void onFile(String filePath, String groupId) {
                result.add(FilePathImpl.create((File)new File(filePath)));
            }
        });
        ContainerUtil.addIfNotNull(result, (Object)this.myMergeTarget);
        return result;
    }

    private void showAlienCommit() {
        final AlienDirtyScope dirtyScope = new AlienDirtyScope();
        if (this.myMergeTarget != null) {
            dirtyScope.addDir((FilePath)this.myMergeTarget);
        } else {
            UpdateFilesHelper.iterateFileGroupFiles((UpdatedFiles)this.myAccumulatedFiles.getUpdatedFiles(), (UpdateFilesHelper.Callback)new UpdateFilesHelper.Callback(){

                public void onFile(String filePath, String groupId) {
                    dirtyScope.addFile((FilePath)FilePathImpl.create((File)new File(filePath)));
                }
            });
        }
        this.showAlienCommit(dirtyScope);
    }

    private void showAlienCommit(final AlienDirtyScope dirtyScope) {
        new Task.Backgroundable(this.myVcs.getProject(), SvnBundle.message("action.Subversion.integrate.changes.collecting.changes.to.commit.task.title", new Object[0])){
            private final GatheringChangelistBuilder changesBuilder;
            private final Ref<String> caughtError;
            {
                super(x0, x1);
                this.changesBuilder = new GatheringChangelistBuilder(SvnIntegrateChangesTask.this.myVcs, SvnIntegrateChangesTask.this.myAccumulatedFiles);
                this.caughtError = new Ref();
            }

            public void run(ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                if (!SvnIntegrateChangesTask.this.myVcs.getProject().isDisposed()) {
                    try {
                        new SvnChangeProvider(SvnIntegrateChangesTask.this.myVcs).getChanges(dirtyScope, (ChangelistBuilder)this.changesBuilder, indicator, null);
                    }
                    catch (VcsException e) {
                        this.caughtError.set((Object)SvnBundle.message("action.Subversion.integrate.changes.error.unable.to.collect.changes.text", e.getMessage()));
                    }
                }
            }

            public void onSuccess() {
                if (!this.caughtError.isNull()) {
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)SvnIntegrateChangesTask.this.myVcs.getProject(), (String)((String)this.caughtError.get()), (MessageType)MessageType.ERROR);
                } else if (!this.changesBuilder.getChanges().isEmpty()) {
                    CommitChangeListDialog.commitAlienChanges((Project)this.myProject, this.changesBuilder.getChanges(), (AbstractVcs)SvnIntegrateChangesTask.this.myVcs, (String)SvnIntegrateChangesTask.this.myMerger.getComment(), (String)SvnIntegrateChangesTask.this.myMerger.getComment());
                }
            }
        }.queue();
    }
}

