/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.lock.LockClient;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(File file, boolean force, String message, ProgressTracker handler) throws VcsException {
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        parameters.add("--message");
        parameters.add(message);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.lock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.LOCKED, EventAction.LOCK_FAILED, handler);
    }

    @Override
    public void unlock(File file, boolean force, ProgressTracker handler) throws VcsException {
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)file), SvnCommandName.unlock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.UNLOCKED, EventAction.UNLOCK_FAILED, handler);
    }

    private static List<String> prepareParameters(File file, boolean force) {
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static void handleCommandCompletion(CommandExecutor command, File file, EventAction success, EventAction failure, ProgressTracker handler) throws VcsException {
        SVNErrorMessage error = SvnUtil.parseWarning(command.getErrorOutput());
        try {
            CmdLockClient.invokeHandler(file, error == null ? success : failure, handler, error);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(File file, EventAction action, ProgressTracker handler, SVNErrorMessage error) throws SVNException {
        if (handler != null) {
            handler.consume(CmdLockClient.createEvent(file, action, error));
        }
    }

    private static ProgressEvent createEvent(File file, EventAction action, SVNErrorMessage error) {
        return new ProgressEvent(file, -1L, null, null, action, error, null);
    }
}

