/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class BranchInfo {
    private static final Logger LOG = Logger.getInstance(BranchInfo.class);
    private final Map<String, Set<Long>> myPathMergedMap;
    private final Map<String, Set<Long>> myNonInheritablePathMergedMap;
    private boolean myMixedRevisionsFound;
    private final Map<Long, SvnMergeInfoCache.MergeCheckResult> myAlreadyCalculatedMap;
    private final Object myCalculatedLock = new Object();
    private final WCInfoWithBranches myInfo;
    private final WCInfoWithBranches.Branch myBranch;
    private final SvnVcs myVcs;
    private SvnMergeInfoCache.CopyRevison myCopyRevison;
    private final MultiMap<Long, String> myPartlyMerged;

    public BranchInfo(SvnVcs vcs, WCInfoWithBranches info, WCInfoWithBranches.Branch branch) {
        this.myVcs = vcs;
        this.myInfo = info;
        this.myBranch = branch;
        this.myPathMergedMap = ContainerUtil.newHashMap();
        this.myPartlyMerged = MultiMap.create();
        this.myNonInheritablePathMergedMap = ContainerUtil.newHashMap();
        this.myAlreadyCalculatedMap = ContainerUtil.newHashMap();
    }

    private long calculateCopyRevision(String branchPath) {
        if (this.myCopyRevison != null && Comparing.equal((String)this.myCopyRevison.getPath(), (String)branchPath)) {
            return this.myCopyRevison.getRevision();
        }
        this.myCopyRevison = new SvnMergeInfoCache.CopyRevison(this.myVcs, branchPath, this.myInfo.getRepoUrl(), this.myBranch.getUrl(), this.myInfo.getRootUrl());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.clear();
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeInfoCached getCached() {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.myCopyRevison != null ? this.myCopyRevison.getRevision() : -1L;
            return new MergeInfoCached(Collections.unmodifiableMap(this.myAlreadyCalculatedMap), revision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMergeInfoCache.MergeCheckResult checkList(final SvnChangeList list, final String branchPath) {
        Object object = this.myCalculatedLock;
        synchronized (object) {
            long revision = this.calculateCopyRevision(branchPath);
            SvnMergeInfoCache.MergeCheckResult result = revision != -1L && revision >= list.getNumber() ? SvnMergeInfoCache.MergeCheckResult.COMMON : (SvnMergeInfoCache.MergeCheckResult)((Object)ContainerUtil.getOrCreate(this.myAlreadyCalculatedMap, (Object)list.getNumber(), (Factory)new Factory<SvnMergeInfoCache.MergeCheckResult>(){

                public SvnMergeInfoCache.MergeCheckResult create() {
                    return BranchInfo.this.checkAlive(list, branchPath);
                }
            }));
            return result;
        }
    }

    private SvnMergeInfoCache.MergeCheckResult checkAlive(SvnChangeList list, String branchPath) {
        Info info = this.myVcs.getInfo(new File(branchPath));
        if (info == null || info.getURL() == null || !SVNPathUtil.isAncestor((String)this.myBranch.getUrl(), (String)info.getURL().toString())) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        String subPathUnderBranch = SVNPathUtil.getRelativePath((String)this.myBranch.getUrl(), (String)info.getURL().toString());
        MultiMap<SvnMergeInfoCache.MergeCheckResult, String> result = this.checkPaths(list, branchPath, subPathUnderBranch);
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS)) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        if (result.containsKey((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED)) {
            this.myPartlyMerged.put((Object)list.getNumber(), result.get((Object)SvnMergeInfoCache.MergeCheckResult.NOT_MERGED));
            return SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        return SvnMergeInfoCache.MergeCheckResult.MERGED;
    }

    private MultiMap<SvnMergeInfoCache.MergeCheckResult, String> checkPaths(SvnChangeList list, String branchPath, String subPathUnderBranch) {
        MultiMap result = MultiMap.create();
        String myTrunkPathCorrespondingToLocalBranchPath = SVNPathUtil.append((String)this.myInfo.getCurrentBranch().getUrl(), (String)subPathUnderBranch);
        for (String path : list.getAffectedPaths()) {
            SvnMergeInfoCache.MergeCheckResult mergeCheckResult;
            String absoluteInTrunkPath = SVNPathUtil.append((String)this.myInfo.getRepoUrl(), (String)path);
            if (!absoluteInTrunkPath.startsWith(myTrunkPathCorrespondingToLocalBranchPath)) {
                mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
            } else {
                String relativeToTrunkPath = absoluteInTrunkPath.substring(myTrunkPathCorrespondingToLocalBranchPath.length());
                String localPathInBranch = new File(branchPath, relativeToTrunkPath).getAbsolutePath();
                try {
                    mergeCheckResult = this.checkPathGoingUp(list.getNumber(), -1L, branchPath, localPathInBranch, path, true);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
                }
            }
            result.putValue((Object)mergeCheckResult, (Object)path);
            if (!SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS.equals((Object)mergeCheckResult)) continue;
            break;
        }
        return result;
    }

    private SvnMergeInfoCache.MergeCheckResult goUp(long revisionAsked, long targetRevision, String branchRootPath, String path, String trunkUrl) throws SVNException, VcsException {
        Info svnInfo;
        String newPath;
        String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
        SvnMergeInfoCache.MergeCheckResult result = newTrunkUrl.length() == 0 || "/".equals(newTrunkUrl) ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : ((newPath = new File(path).getParent()).length() < branchRootPath.length() ? (targetRevision == -1L ? SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS : ((svnInfo = this.myVcs.getInfo(new File(branchRootPath))) == null || svnInfo.getURL() == null ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, svnInfo.getURL().removePathTail(), newTrunkUrl))) : this.checkPathGoingUp(revisionAsked, targetRevision, branchRootPath, newPath, newTrunkUrl, false));
        return result;
    }

    private SvnMergeInfoCache.MergeCheckResult goUpInRepo(long revisionAsked, long targetRevision, SVNURL branchUrl, String trunkUrl) throws VcsException, SVNException {
        SvnMergeInfoCache.MergeCheckResult result;
        Set<Long> mergeInfo = this.myPathMergedMap.get(branchUrl.toString() + "@" + targetRevision);
        if (mergeInfo != null) {
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(mergeInfo.contains(revisionAsked));
        } else {
            SvnTarget target = SvnTarget.fromURL((SVNURL)branchUrl);
            PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, SVNRevision.create((long)targetRevision));
            if (mergeinfoProperty == null) {
                String newTrunkUrl = SVNPathUtil.removeTail((String)trunkUrl).trim();
                SVNURL newBranchUrl = branchUrl.removePathTail();
                String absoluteTrunk = SVNPathUtil.append((String)this.myInfo.getRepoUrl(), (String)newTrunkUrl);
                result = newTrunkUrl.length() <= 1 || newBranchUrl.toString().length() <= this.myInfo.getRepoUrl().length() || newBranchUrl.toString().equals(absoluteTrunk) ? SvnMergeInfoCache.MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, newBranchUrl, newTrunkUrl);
            } else {
                result = this.processMergeinfoProperty(branchUrl.toString() + "@" + targetRevision, revisionAsked, mergeinfoProperty, trunkUrl, false);
            }
        }
        return result;
    }

    private SvnMergeInfoCache.MergeCheckResult checkPathGoingUp(long revisionAsked, long targetRevision, String branchRootPath, String path, String trunkUrl, boolean self) throws VcsException, SVNException {
        SvnMergeInfoCache.MergeCheckResult result;
        File pathFile = new File(path);
        if (targetRevision == -1L && !pathFile.exists()) {
            result = this.goUp(revisionAsked, targetRevision, branchRootPath, path, trunkUrl);
        } else {
            Info svnInfo = this.myVcs.getInfo(pathFile);
            if (svnInfo == null || svnInfo.getURL() == null) {
                LOG.info("Svninfo for " + pathFile + " is null or not full.");
                result = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
            } else {
                long actualRevision = svnInfo.getRevision().getNumber();
                long targetRevisionCorrected = targetRevision == -1L ? actualRevision : targetRevision;
                String keyString = path + "@" + targetRevisionCorrected;
                Set<Long> selfInfo = self ? this.myNonInheritablePathMergedMap.get(keyString) : null;
                Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
                if (mergeInfo != null || selfInfo != null) {
                    boolean merged = mergeInfo != null && mergeInfo.contains(revisionAsked) || selfInfo != null && selfInfo.contains(revisionAsked);
                    result = SvnMergeInfoCache.MergeCheckResult.getInstance(merged);
                } else {
                    SVNRevision revision;
                    SvnTarget target;
                    if (actualRevision != targetRevisionCorrected) {
                        this.myMixedRevisionsFound = true;
                    }
                    if (actualRevision == targetRevisionCorrected) {
                        target = SvnTarget.fromFile((File)pathFile, (SVNRevision)SVNRevision.WORKING);
                        revision = SVNRevision.WORKING;
                    } else {
                        target = SvnTarget.fromURL((SVNURL)svnInfo.getURL());
                        revision = SVNRevision.create((long)targetRevisionCorrected);
                    }
                    PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, revision);
                    result = mergeinfoProperty == null ? this.goUp(revisionAsked, targetRevisionCorrected, branchRootPath, path, trunkUrl) : this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, trunkUrl, self);
                }
            }
        }
        return result;
    }

    private SvnMergeInfoCache.MergeCheckResult processMergeinfoProperty(String pathWithRevisionNumber, final long revisionAsked, PropertyValue value, final String trunkRelativeUrl, final boolean self) throws SvnBindException {
        SvnMergeInfoCache.MergeCheckResult result;
        Map<String, SVNMergeRangeList> mergedPathsMap = BranchInfo.parseMergeInfo(value);
        String mergedPathAffectingTrunkUrl = (String)ContainerUtil.find(mergedPathsMap.keySet(), (Condition)new Condition<String>(){

            public boolean value(String path) {
                return trunkRelativeUrl.startsWith(path);
            }
        });
        if (mergedPathAffectingTrunkUrl != null) {
            SVNMergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingTrunkUrl);
            this.fillMergedRevisions(pathWithRevisionNumber, mergeRangeList);
            boolean isAskedRevisionMerged = ContainerUtil.or((Object[])mergeRangeList.getRanges(), (Condition)new Condition<SVNMergeRange>(){

                public boolean value(SVNMergeRange range) {
                    return BranchInfo.isInRange(range, revisionAsked) && (range.isInheritable() || self);
                }
            });
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(isAskedRevisionMerged);
        } else {
            this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
            result = SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        }
        return result;
    }

    public static Map<String, SVNMergeRangeList> parseMergeInfo(PropertyValue value) throws SvnBindException {
        try {
            return SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(value.toString().replace('\r', '\n').replace("\n\n", "\n")), null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private void fillMergedRevisions(String pathWithRevisionNumber, SVNMergeRangeList mergeRangeList) {
        HashSet revisions = ContainerUtil.newHashSet();
        HashSet nonInheritableRevisions = ContainerUtil.newHashSet();
        for (SVNMergeRange range : mergeRangeList.getRanges()) {
            (range.isInheritable() ? revisions : nonInheritableRevisions).addAll(BranchInfo.toRevisionsList(range));
        }
        this.myPathMergedMap.put(pathWithRevisionNumber, revisions);
        if (!nonInheritableRevisions.isEmpty()) {
            this.myNonInheritablePathMergedMap.put(pathWithRevisionNumber, nonInheritableRevisions);
        }
    }

    private static Collection<Long> toRevisionsList(SVNMergeRange range) {
        ArrayList result = ContainerUtil.newArrayList();
        for (long i = range.getStartRevision() + 1L; i <= range.getEndRevision(); ++i) {
            result.add(i);
        }
        return result;
    }

    public static boolean isInRange(SVNMergeRange range, long revision) {
        return revision > range.getStartRevision() && revision <= range.getEndRevision();
    }

    public boolean isMixedRevisionsFound() {
        return this.myMixedRevisionsFound;
    }

    public Collection<String> getNotMergedPaths(long number) {
        return this.myPartlyMerged.get((Object)number);
    }
}

