/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class CmdPropertyClient
extends BaseSvnClient
implements PropertyClient {
    private static final Logger LOG = Logger.getInstance(CmdPropertyClient.class);

    @Override
    public PropertyValue getProperty(SvnTarget target, String property, boolean revisionProperty, SVNRevision revision) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        if (!revisionProperty) {
            CommandUtil.put(parameters, target);
            CommandUtil.put(parameters, revision);
        } else {
            this.assertFile(target);
            CommandUtil.put(parameters, target, false);
            parameters.add("--revprop");
            CommandUtil.put(parameters, this.resolveRevisionNumber(target.getFile(), revision));
        }
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        PropertyData data = this.parseSingleProperty(target, command);
        return data != null ? data.getValue() : null;
    }

    @Override
    public void getProperty(SvnTarget target, String property, SVNRevision revision, Depth depth, PropertyConsumer handler) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(property);
        this.fillListParameters(target, revision, depth, parameters, false);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.propget, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void list(SvnTarget target, SVNRevision revision, Depth depth, PropertyConsumer handler) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        this.fillListParameters(target, revision, depth, parameters, true);
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.proplist, parameters, null);
        CmdPropertyClient.parseOutput(target, command, handler);
    }

    @Override
    public void setProperty(File file, String property, PropertyValue value, Depth depth, boolean force) throws VcsException {
        this.runSetProperty(SvnTarget.fromFile((File)file), property, null, depth, value, force);
    }

    @Override
    public void setProperties(File file, PropertiesMap properties) throws VcsException {
        PropertiesMap currentProperties = this.collectPropertiesToDelete(file);
        currentProperties.putAll((Map)((Object)properties));
        for (Map.Entry entry : currentProperties.entrySet()) {
            this.setProperty(file, (String)entry.getKey(), (PropertyValue)entry.getValue(), Depth.EMPTY, true);
        }
    }

    private PropertiesMap collectPropertiesToDelete(File file) throws VcsException {
        final PropertiesMap result = new PropertiesMap();
        this.list(SvnTarget.fromFile((File)file), null, Depth.EMPTY, new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                result.put(property.getName(), null);
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }
        });
        return result;
    }

    @Override
    public void setRevisionProperty(SvnTarget target, String property, SVNRevision revision, PropertyValue value, boolean force) throws VcsException {
        this.runSetProperty(target, property, revision, null, value, force);
    }

    private void runSetProperty(SvnTarget target, String property, SVNRevision revision, Depth depth, PropertyValue value, boolean force) throws VcsException {
        boolean isDelete = value == null;
        Command command = this.newCommand(isDelete ? SvnCommandName.propdel : SvnCommandName.propset);
        command.put(property);
        if (revision != null) {
            command.put("--revprop");
            command.put(revision);
        }
        if (!isDelete) {
            command.setPropertyValue(value);
            command.put("--force", force);
        }
        command.put(target);
        command.put(depth);
        this.execute(this.myVcs, target, null, command, null);
    }

    private void fillListParameters(SvnTarget target, SVNRevision revision, Depth depth, List<String> parameters, boolean verbose) {
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, revision);
        CommandUtil.put(parameters, depth);
        parameters.add("--xml");
        CommandUtil.put(parameters, verbose, "--verbose");
    }

    private PropertyData parseSingleProperty(SvnTarget target, CommandExecutor command) throws VcsException {
        final PropertyData[] data = new PropertyData[1];
        PropertyConsumer handler = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                data[0] = property;
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
                data[0] = property;
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
                data[0] = property;
            }
        };
        CmdPropertyClient.parseOutput(target, command, handler);
        return data[0];
    }

    private static void parseOutput(SvnTarget target, CommandExecutor command, PropertyConsumer handler) throws VcsException {
        try {
            Properties properties = CommandUtil.parse(command.getOutput(), Properties.class);
            if (properties != null) {
                for (Target childInfo : properties.targets) {
                    SvnTarget childTarget = SvnUtil.append(target, childInfo.path);
                    for (Property property : childInfo.properties) {
                        CmdPropertyClient.invokeHandler(childTarget, CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
                if (properties.revisionProperties != null) {
                    for (Property property : properties.revisionProperties.properties) {
                        CmdPropertyClient.invokeHandler(properties.revisionProperties.revisionNumber(), CmdPropertyClient.create(property.name, property.value), handler);
                    }
                }
            }
        }
        catch (JAXBException e) {
            LOG.error("Could not parse properties. Command: " + command.getCommandText() + ", Warning: " + command.getErrorOutput(), new Attachment[]{new Attachment("output.xml", command.getOutput())});
            throw new VcsException((Throwable)e);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(SvnTarget target, PropertyData data, PropertyConsumer handler) throws SVNException {
        if (handler != null && data != null) {
            if (target.isFile()) {
                handler.handleProperty(target.getFile(), data);
            } else {
                handler.handleProperty(target.getURL(), data);
            }
        }
    }

    private static void invokeHandler(long revision, PropertyData data, PropertyConsumer handler) throws SVNException {
        if (handler != null && data != null) {
            handler.handleProperty(revision, data);
        }
    }

    private static PropertyData create(String property, String value) {
        PropertyData result = null;
        if (value != null) {
            result = new PropertyData(property, PropertyValue.create(value.trim()));
        }
        return result;
    }

    private SVNRevision resolveRevisionNumber(File path, SVNRevision revision) throws VcsException {
        long result;
        long l = result = revision != null ? revision.getNumber() : -1L;
        if (SVNRevision.BASE.equals((Object)revision)) {
            Info info = this.myVcs.getInfo(path, SVNRevision.BASE);
            long l2 = result = info != null ? info.getRevision().getNumber() : -1L;
        }
        if (result == -1L) {
            throw new VcsException("Could not determine revision number for file " + path + " and revision " + revision);
        }
        return SVNRevision.create((long)result);
    }

    public static class Property {
        @XmlAttribute(name="name")
        public String name;
        @XmlValue
        public String value;
    }

    public static class RevisionProperties {
        @XmlAttribute(name="rev")
        public String revision;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();

        public long revisionNumber() {
            return Long.valueOf(this.revision);
        }
    }

    public static class Target {
        @XmlAttribute(name="path")
        public String path;
        @XmlElement(name="property")
        public List<Property> properties = new ArrayList<Property>();
    }

    @XmlRootElement(name="properties")
    public static class Properties {
        @XmlElement(name="target")
        public List<Target> targets = new ArrayList<Target>();
        @XmlElement(name="revprops")
        public RevisionProperties revisionProperties;
    }
}

