/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.properties;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.util.Map;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.properties.PropertiesMap;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyValueProvider;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnKitPropertyClient
extends BaseSvnClient
implements PropertyClient {
    public static final ISVNOptions LF_SEPARATOR_OPTIONS = new DefaultSVNOptions(){

        public byte[] getNativeEOL() {
            return CharsetToolkit.getUtf8Bytes((String)LineSeparator.LF.getSeparatorString());
        }
    };

    @Override
    public PropertyValue getProperty(SvnTarget target, String property, boolean revisionProperty, SVNRevision revision) throws VcsException {
        PropertyData resultData;
        try {
            resultData = !revisionProperty ? (target.isFile() ? PropertyData.create(this.createClient().doGetProperty(target.getFile(), property, target.getPegRevision(), revision)) : PropertyData.create(this.createClient().doGetProperty(target.getURL(), property, target.getPegRevision(), revision))) : this.getRevisionProperty(target, property, revision);
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
        return resultData != null ? resultData.getValue() : null;
    }

    private SVNWCClient createClient() {
        SVNWCClient client = this.myVcs.getSvnKitManager().createWCClient();
        client.setOptions(LF_SEPARATOR_OPTIONS);
        return client;
    }

    @Override
    public void getProperty(SvnTarget target, String property, SVNRevision revision, Depth depth, PropertyConsumer handler) throws VcsException {
        this.runGetProperty(target, property, revision, depth, handler);
    }

    @Override
    public void list(SvnTarget target, SVNRevision revision, Depth depth, PropertyConsumer handler) throws VcsException {
        this.runGetProperty(target, null, revision, depth, handler);
    }

    @Override
    public void setProperty(File file, String property, PropertyValue value, Depth depth, boolean force) throws VcsException {
        try {
            this.createClient().doSetProperty(file, property, SvnKitPropertyClient.toPropertyValue(value), force, SvnKitPropertyClient.toDepth(depth), null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setProperties(File file, PropertiesMap properties) throws VcsException {
        final SVNProperties propertiesToSet = SvnKitPropertyClient.toSvnProperties(properties);
        try {
            this.createClient().doSetProperty(file, new ISVNPropertyValueProvider(){

                public SVNProperties providePropertyValues(File path, SVNProperties properties) throws SVNException {
                    return propertiesToSet;
                }
            }, true, SVNDepth.EMPTY, null, null);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public void setRevisionProperty(SvnTarget target, String property, SVNRevision revision, PropertyValue value, boolean force) throws VcsException {
        try {
            if (target.isFile()) {
                this.createClient().doSetRevisionProperty(target.getFile(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            } else {
                this.createClient().doSetRevisionProperty(target.getURL(), revision, property, SvnKitPropertyClient.toPropertyValue(value), force, null);
            }
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private static SVNProperties toSvnProperties(PropertiesMap properties) {
        SVNProperties result = new SVNProperties();
        for (Map.Entry entry : properties.entrySet()) {
            result.put((String)entry.getKey(), SvnKitPropertyClient.toPropertyValue((PropertyValue)entry.getValue()));
        }
        return result;
    }

    private void runGetProperty(SvnTarget target, String property, SVNRevision revision, Depth depth, PropertyConsumer handler) throws VcsException {
        SVNWCClient client = this.createClient();
        try {
            if (target.isURL()) {
                client.doGetProperty(target.getURL(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler));
            } else {
                client.doGetProperty(target.getFile(), property, target.getPegRevision(), revision, SvnKitPropertyClient.toDepth(depth), SvnKitPropertyClient.toHandler(handler), null);
            }
        }
        catch (SVNException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private PropertyData getRevisionProperty(SvnTarget target, final String property, SVNRevision revision) throws SVNException {
        SVNWCClient client = this.createClient();
        final PropertyData[] result = new PropertyData[1];
        ISVNPropertyHandler handler = new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(SVNURL url, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            public void handleProperty(long revision, SVNPropertyData property2) throws SVNException {
                this.handle(property2);
            }

            private void handle(SVNPropertyData data) {
                if (property.equals(data.getName())) {
                    result[0] = PropertyData.create(data);
                }
            }
        };
        if (target.isFile()) {
            client.doGetRevisionProperty(target.getFile(), null, revision, handler);
        } else {
            client.doGetRevisionProperty(target.getURL(), null, revision, handler);
        }
        return result[0];
    }

    private static ISVNPropertyHandler toHandler(final PropertyConsumer consumer) {
        ISVNPropertyHandler result = null;
        if (consumer != null) {
            result = new ISVNPropertyHandler(){

                public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(path, PropertyData.create(property));
                }

                public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(url, PropertyData.create(property));
                }

                public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
                    consumer.handleProperty(revision, PropertyData.create(property));
                }
            };
        }
        return result;
    }

    private static SVNPropertyValue toPropertyValue(PropertyValue value) {
        SVNPropertyValue result = null;
        if (value != null) {
            result = SVNPropertyValue.create((String)value.toString());
        }
        return result;
    }
}

