/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import java.io.File;
import java.util.Collection;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusFileProvider;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class SvnKitStatusClient
extends BaseSvnClient
implements StatusClient {
    private SVNStatusClient myStatusClient;
    private final ISVNStatusFileProvider myProvider;
    private final ProgressTracker myHandler;

    public SvnKitStatusClient() {
        this(null, null);
    }

    public SvnKitStatusClient(ISVNStatusFileProvider provider, ProgressTracker handler) {
        this.myProvider = provider;
        this.myHandler = handler;
    }

    @Override
    public long doStatus(File path, SVNRevision revision, Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, final StatusConsumer handler, Collection changeLists) throws SvnBindException {
        try {
            return this.getStatusClient().doStatus(path, revision, SvnKitStatusClient.toDepth(depth), remote, reportAll, includeIgnored, collectParentExternals, new ISVNStatusHandler(){

                public void handleStatus(SVNStatus status) throws SVNException {
                    handler.consume(Status.create(status));
                }
            }, changeLists);
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    @Override
    public Status doStatus(File path, boolean remote) throws SvnBindException {
        try {
            return Status.create(this.getStatusClient().doStatus(path, remote));
        }
        catch (SVNException e) {
            throw new SvnBindException(e);
        }
    }

    private SVNStatusClient getStatusClient() {
        return this.myHandler != null || this.myProvider != null ? this.ensureStatusClient() : this.myVcs.getSvnKitManager().createStatusClient();
    }

    private SVNStatusClient ensureStatusClient() {
        if (this.myStatusClient == null) {
            this.myStatusClient = this.myVcs.getSvnKitManager().createStatusClient();
            this.myStatusClient.setFilesProvider(this.myProvider);
            this.myStatusClient.setEventHandler(SvnKitStatusClient.toEventHandler(this.myHandler));
        }
        return this.myStatusClient;
    }
}

