/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.ico;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.Sanselan;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.bmp.BmpImageParser;
import org.apache.sanselan.palette.PaletteFactory;
import org.apache.sanselan.palette.SimplePalette;
import org.apache.sanselan.util.Debug;

public class IcoImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".ico";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".ico", ".cur"};

    public IcoImageParser() {
        super.setByteOrder(73);
    }

    @Override
    public String getName() {
        return "ico-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_ICO};
    }

    @Override
    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private FileHeader readFileHeader(InputStream is) throws ImageReadException, IOException {
        int Reserved = this.read2Bytes("Reserved", is, "Not a Valid ICO File");
        int IconType = this.read2Bytes("IconType", is, "Not a Valid ICO File");
        int IconCount = this.read2Bytes("IconCount", is, "Not a Valid ICO File");
        if (Reserved != 0) {
            throw new ImageReadException("Not a Valid ICO File: reserved is " + Reserved);
        }
        if (IconType != 1 && IconType != 2) {
            throw new ImageReadException("Not a Valid ICO File: icon type is " + IconType);
        }
        return new FileHeader(Reserved, IconType, IconCount);
    }

    private IconInfo readIconInfo(InputStream is) throws ImageReadException, IOException {
        byte Width = this.readByte("Width", is, "Not a Valid ICO File");
        byte Height = this.readByte("Height", is, "Not a Valid ICO File");
        byte ColorCount2 = this.readByte("ColorCount", is, "Not a Valid ICO File");
        byte Reserved = this.readByte("Reserved", is, "Not a Valid ICO File");
        int Planes = this.read2Bytes("Planes", is, "Not a Valid ICO File");
        int BitCount = this.read2Bytes("BitCount", is, "Not a Valid ICO File");
        int ImageSize = this.read4Bytes("ImageSize", is, "Not a Valid ICO File");
        int ImageOffset = this.read4Bytes("ImageOffset", is, "Not a Valid ICO File");
        return new IconInfo(Width, Height, ColorCount2, Reserved, Planes, BitCount, ImageSize, ImageOffset);
    }

    private IconData readBitmapIconData(byte[] iconData, IconInfo fIconInfo) throws ImageReadException, ImageWriteException, IOException {
        BufferedImage resultImage;
        byte[] transparency_map;
        int t_scanline_size;
        BufferedImage bmpImage;
        BitmapHeader header;
        int BitCount;
        block15: {
            ByteArrayInputStream is = new ByteArrayInputStream(iconData);
            int Size = this.read4Bytes("Size", is, "Not a Valid ICO File");
            int Width = this.read4Bytes("Width", is, "Not a Valid ICO File");
            int Height = this.read4Bytes("Height", is, "Not a Valid ICO File");
            int Planes = this.read2Bytes("Planes", is, "Not a Valid ICO File");
            BitCount = this.read2Bytes("BitCount", is, "Not a Valid ICO File");
            int Compression2 = this.read4Bytes("Compression", is, "Not a Valid ICO File");
            int SizeImage = this.read4Bytes("SizeImage", is, "Not a Valid ICO File");
            int XPelsPerMeter = this.read4Bytes("XPelsPerMeter", is, "Not a Valid ICO File");
            int YPelsPerMeter = this.read4Bytes("YPelsPerMeter", is, "Not a Valid ICO File");
            int ColorsUsed = this.read4Bytes("ColorsUsed", is, "Not a Valid ICO File");
            int ColorsImportant = this.read4Bytes("ColorsImportant", is, "Not a Valid ICO File");
            int RedMask = 0;
            int GreenMask = 0;
            int BlueMask = 0;
            int AlphaMask = 0;
            if (Compression2 == 3) {
                RedMask = this.read4Bytes("RedMask", is, "Not a Valid ICO File");
                GreenMask = this.read4Bytes("GreenMask", is, "Not a Valid ICO File");
                BlueMask = this.read4Bytes("BlueMask", is, "Not a Valid ICO File");
            }
            byte[] RestOfFile = this.readByteArray("RestOfFile", is.available(), is);
            if (Size != 40) {
                throw new ImageReadException("Not a Valid ICO File: Wrong bitmap header size " + Size);
            }
            if (Planes != 1) {
                throw new ImageReadException("Not a Valid ICO File: Planes can't be " + Planes);
            }
            if (Compression2 == 0 && BitCount == 32) {
                Compression2 = 3;
                RedMask = 0xFF0000;
                GreenMask = 65280;
                BlueMask = 255;
                AlphaMask = -16777216;
            }
            header = new BitmapHeader(Size, Width, Height, Planes, BitCount, Compression2, SizeImage, XPelsPerMeter, YPelsPerMeter, ColorsUsed, ColorsImportant);
            int bitmapPixelsOffset = 70 + 4 * (ColorsUsed == 0 && BitCount <= 8 ? 1 << BitCount : ColorsUsed);
            int bitmapSize = 70 + RestOfFile.length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bitmapSize);
            BinaryOutputStream bos = new BinaryOutputStream(baos, 73);
            bos.write(66);
            bos.write(77);
            bos.write4Bytes(bitmapSize);
            bos.write4Bytes(0);
            bos.write4Bytes(bitmapPixelsOffset);
            bos.write4Bytes(56);
            bos.write4Bytes(Width);
            bos.write4Bytes(Height / 2);
            bos.write2Bytes(Planes);
            bos.write2Bytes(BitCount);
            bos.write4Bytes(Compression2);
            bos.write4Bytes(SizeImage);
            bos.write4Bytes(XPelsPerMeter);
            bos.write4Bytes(YPelsPerMeter);
            bos.write4Bytes(ColorsUsed);
            bos.write4Bytes(ColorsImportant);
            bos.write4Bytes(RedMask);
            bos.write4Bytes(GreenMask);
            bos.write4Bytes(BlueMask);
            bos.write4Bytes(AlphaMask);
            bos.write(RestOfFile);
            bos.flush();
            ByteArrayInputStream bmpInputStream = new ByteArrayInputStream(baos.toByteArray());
            bmpImage = new BmpImageParser().getBufferedImage(bmpInputStream, null);
            t_scanline_size = (Width + 7) / 8;
            if (t_scanline_size % 4 != 0) {
                t_scanline_size += 4 - t_scanline_size % 4;
            }
            int tcolor_map_size_bytes = t_scanline_size * (Height / 2);
            transparency_map = null;
            try {
                transparency_map = this.readByteArray("transparency_map", tcolor_map_size_bytes, bmpInputStream, "Not a Valid ICO File");
            }
            catch (IOException ioEx) {
                if (BitCount == 32) break block15;
                throw ioEx;
            }
        }
        boolean allAlphasZero = true;
        if (BitCount == 32) {
            block2: for (int y = 0; allAlphasZero && y < bmpImage.getHeight(); ++y) {
                for (int x = 0; x < bmpImage.getWidth(); ++x) {
                    if ((bmpImage.getRGB(x, y) & 0xFF000000) == 0) continue;
                    allAlphasZero = false;
                    continue block2;
                }
            }
        }
        if (allAlphasZero) {
            resultImage = new BufferedImage(bmpImage.getWidth(), bmpImage.getHeight(), 2);
            for (int y = 0; y < resultImage.getHeight(); ++y) {
                for (int x = 0; x < resultImage.getWidth(); ++x) {
                    int alpha = 255;
                    if (transparency_map != null) {
                        int alpha_byte = 0xFF & transparency_map[t_scanline_size * (bmpImage.getHeight() - y - 1) + x / 8];
                        alpha = 1 & alpha_byte >> 7 - x % 8;
                        alpha = alpha == 0 ? 255 : 0;
                    }
                    resultImage.setRGB(x, y, alpha << 24 | 0xFFFFFF & bmpImage.getRGB(x, y));
                }
            }
        } else {
            resultImage = bmpImage;
        }
        return new BitmapIconData(fIconInfo, header, resultImage);
    }

    private IconData readIconData(byte[] iconData, IconInfo fIconInfo) throws ImageReadException, IOException {
        ImageFormat imageFormat = Sanselan.guessFormat(iconData);
        if (imageFormat.equals(ImageFormat.IMAGE_FORMAT_PNG)) {
            BufferedImage bufferedImage = Sanselan.getBufferedImage(iconData);
            PNGIconData pngIconData = new PNGIconData(fIconInfo, bufferedImage);
            return pngIconData;
        }
        try {
            return this.readBitmapIconData(iconData, fIconInfo);
        }
        catch (ImageWriteException imageWriteException) {
            IOException ioe = new IOException();
            ioe.initCause(imageWriteException);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageContents readImage(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileHeader fileHeader = this.readFileHeader(is);
            IconInfo[] fIconInfos = new IconInfo[fileHeader.iconCount];
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                fIconInfos[i] = this.readIconInfo(is);
            }
            IconData[] fIconDatas = new IconData[fileHeader.iconCount];
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                byte[] iconData = byteSource.getBlock(fIconInfos[i].ImageOffset, fIconInfos[i].ImageSize);
                fIconDatas[i] = this.readIconData(iconData, fIconInfos[i]);
            }
            ImageContents imageContents = new ImageContents(fileHeader, fIconDatas);
            return imageContents;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        ImageContents contents = this.readImage(byteSource);
        contents.fileHeader.dump(pw);
        for (int i = 0; i < contents.iconDatas.length; ++i) {
            contents.iconDatas[i].dump(pw);
        }
        return true;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        if (fileHeader.iconCount > 0) {
            return contents.iconDatas[0].readBufferedImage();
        }
        throw new ImageReadException("No icons in ICO file");
    }

    @Override
    public ArrayList getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        for (int i = 0; i < fileHeader.iconCount; ++i) {
            IconData iconData = contents.iconDatas[i];
            BufferedImage image = iconData.readBufferedImage();
            result.add(image);
        }
        return result;
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        int t_scanline_size;
        HashMap hashMap = params = params == null ? new HashMap() : new HashMap(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        if (params.size() > 0) {
            Object firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
        PaletteFactory paletteFactory = new PaletteFactory();
        SimplePalette palette = paletteFactory.makePaletteSimple(src, 256);
        boolean hasTransparency = paletteFactory.hasTransparency(src);
        int bitCount = palette == null ? (hasTransparency ? 32 : 24) : (palette.length() <= 2 ? 1 : (palette.length() <= 16 ? 4 : 8));
        BinaryOutputStream bos = new BinaryOutputStream(os, 73);
        int scanline_size = (bitCount * src.getWidth() + 7) / 8;
        if (scanline_size % 4 != 0) {
            scanline_size += 4 - scanline_size % 4;
        }
        if ((t_scanline_size = (src.getWidth() + 7) / 8) % 4 != 0) {
            t_scanline_size += 4 - t_scanline_size % 4;
        }
        int imageSize = 40 + 4 * (bitCount <= 8 ? 1 << bitCount : 0) + src.getHeight() * scanline_size + src.getHeight() * t_scanline_size;
        bos.write2Bytes(0);
        bos.write2Bytes(1);
        bos.write2Bytes(1);
        int iconDirEntryWidth = src.getWidth();
        int iconDirEntryHeight = src.getHeight();
        if (iconDirEntryWidth > 255 || iconDirEntryHeight > 255) {
            iconDirEntryWidth = 0;
            iconDirEntryHeight = 0;
        }
        bos.write(iconDirEntryWidth);
        bos.write(iconDirEntryHeight);
        bos.write(bitCount >= 8 ? 0 : 1 << bitCount);
        bos.write(0);
        bos.write2Bytes(1);
        bos.write2Bytes(bitCount);
        bos.write4Bytes(imageSize);
        bos.write4Bytes(22);
        bos.write4Bytes(40);
        bos.write4Bytes(src.getWidth());
        bos.write4Bytes(2 * src.getHeight());
        bos.write2Bytes(1);
        bos.write2Bytes(bitCount);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        bos.write4Bytes(0);
        if (palette != null) {
            for (int i = 0; i < 1 << bitCount; ++i) {
                if (i < palette.length()) {
                    int argb = palette.getEntry(i);
                    bos.write(0xFF & argb);
                    bos.write(0xFF & argb >> 8);
                    bos.write(0xFF & argb >> 16);
                    bos.write(0);
                    continue;
                }
                bos.write(0);
                bos.write(0);
                bos.write(0);
                bos.write(0);
            }
        }
        int bit_cache = 0;
        int bits_in_cache = 0;
        int row_padding = scanline_size - (bitCount * src.getWidth() + 7) / 8;
        for (int y = src.getHeight() - 1; y >= 0; --y) {
            int x;
            for (x = 0; x < src.getWidth(); ++x) {
                int index;
                int rgb;
                int argb = src.getRGB(x, y);
                if (bitCount < 8) {
                    rgb = 0xFFFFFF & argb;
                    index = palette.getPaletteIndex(rgb);
                    bit_cache <<= bitCount;
                    bit_cache |= index;
                    if ((bits_in_cache += bitCount) < 8) continue;
                    bos.write(0xFF & bit_cache);
                    bit_cache = 0;
                    bits_in_cache = 0;
                    continue;
                }
                if (bitCount == 8) {
                    rgb = 0xFFFFFF & argb;
                    index = palette.getPaletteIndex(rgb);
                    bos.write(0xFF & index);
                    continue;
                }
                if (bitCount == 24) {
                    bos.write(0xFF & argb);
                    bos.write(0xFF & argb >> 8);
                    bos.write(0xFF & argb >> 16);
                    continue;
                }
                if (bitCount != 32) continue;
                bos.write(0xFF & argb);
                bos.write(0xFF & argb >> 8);
                bos.write(0xFF & argb >> 16);
                bos.write(0xFF & argb >> 24);
            }
            if (bits_in_cache > 0) {
                bos.write(0xFF & (bit_cache <<= 8 - bits_in_cache));
                bit_cache = 0;
                bits_in_cache = 0;
            }
            for (x = 0; x < row_padding; ++x) {
                bos.write(0);
            }
        }
        int t_row_padding = t_scanline_size - (src.getWidth() + 7) / 8;
        for (int y = src.getHeight() - 1; y >= 0; --y) {
            int x;
            for (x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int alpha = 0xFF & argb >> 24;
                bit_cache <<= 1;
                if (alpha == 0) {
                    bit_cache |= 1;
                }
                if (++bits_in_cache < 8) continue;
                bos.write(0xFF & bit_cache);
                bit_cache = 0;
                bits_in_cache = 0;
            }
            if (bits_in_cache > 0) {
                bos.write(0xFF & (bit_cache <<= 8 - bits_in_cache));
                bit_cache = 0;
                bits_in_cache = 0;
            }
            for (x = 0; x < t_row_padding; ++x) {
                bos.write(0);
            }
        }
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private static class ImageContents {
        public final FileHeader fileHeader;
        public final IconData[] iconDatas;

        public ImageContents(FileHeader fileHeader, IconData[] iconDatas) {
            this.fileHeader = fileHeader;
            this.iconDatas = iconDatas;
        }
    }

    private static class PNGIconData
    extends IconData {
        public final BufferedImage bufferedImage;

        public PNGIconData(IconInfo iconInfo, BufferedImage bufferedImage) {
            super(iconInfo);
            this.bufferedImage = bufferedImage;
        }

        @Override
        public BufferedImage readBufferedImage() {
            return this.bufferedImage;
        }

        @Override
        protected void dumpSubclass(PrintWriter pw) {
            pw.println("PNGIconData");
            pw.println();
        }
    }

    private static class BitmapIconData
    extends IconData {
        public final BitmapHeader header;
        public final BufferedImage bufferedImage;

        public BitmapIconData(IconInfo iconInfo, BitmapHeader header, BufferedImage bufferedImage) {
            super(iconInfo);
            this.header = header;
            this.bufferedImage = bufferedImage;
        }

        @Override
        public BufferedImage readBufferedImage() throws ImageReadException {
            return this.bufferedImage;
        }

        @Override
        protected void dumpSubclass(PrintWriter pw) {
            pw.println("BitmapIconData");
            this.header.dump(pw);
            pw.println();
        }
    }

    private static abstract class IconData {
        public final IconInfo iconInfo;

        public IconData(IconInfo iconInfo) {
            this.iconInfo = iconInfo;
        }

        public void dump(PrintWriter pw) {
            this.iconInfo.dump(pw);
            pw.println();
            this.dumpSubclass(pw);
        }

        protected abstract void dumpSubclass(PrintWriter var1);

        public abstract BufferedImage readBufferedImage() throws ImageReadException;
    }

    private static class BitmapHeader {
        public final int Size;
        public final int Width;
        public final int Height;
        public final int Planes;
        public final int BitCount;
        public final int Compression;
        public final int SizeImage;
        public final int XPelsPerMeter;
        public final int YPelsPerMeter;
        public final int ColorsUsed;
        public final int ColorsImportant;

        public BitmapHeader(int size, int width, int height, int planes, int bitCount, int compression, int sizeImage, int pelsPerMeter, int pelsPerMeter2, int colorsUsed, int colorsImportant) {
            this.Size = size;
            this.Width = width;
            this.Height = height;
            this.Planes = planes;
            this.BitCount = bitCount;
            this.Compression = compression;
            this.SizeImage = sizeImage;
            this.XPelsPerMeter = pelsPerMeter;
            this.YPelsPerMeter = pelsPerMeter2;
            this.ColorsUsed = colorsUsed;
            this.ColorsImportant = colorsImportant;
        }

        public void dump(PrintWriter pw) {
            pw.println("BitmapHeader");
            pw.println("Size: " + this.Size);
            pw.println("Width: " + this.Width);
            pw.println("Height: " + this.Height);
            pw.println("Planes: " + this.Planes);
            pw.println("BitCount: " + this.BitCount);
            pw.println("Compression: " + this.Compression);
            pw.println("SizeImage: " + this.SizeImage);
            pw.println("XPelsPerMeter: " + this.XPelsPerMeter);
            pw.println("YPelsPerMeter: " + this.YPelsPerMeter);
            pw.println("ColorsUsed: " + this.ColorsUsed);
            pw.println("ColorsImportant: " + this.ColorsImportant);
        }
    }

    private static class IconInfo {
        public final byte Width;
        public final byte Height;
        public final byte ColorCount;
        public final byte Reserved;
        public final int Planes;
        public final int BitCount;
        public final int ImageSize;
        public final int ImageOffset;

        public IconInfo(byte width, byte height, byte colorCount, byte reserved, int planes, int bitCount, int imageSize, int imageOffset) {
            this.Width = width;
            this.Height = height;
            this.ColorCount = colorCount;
            this.Reserved = reserved;
            this.Planes = planes;
            this.BitCount = bitCount;
            this.ImageSize = imageSize;
            this.ImageOffset = imageOffset;
        }

        public void dump(PrintWriter pw) {
            pw.println("IconInfo");
            pw.println("Width: " + this.Width);
            pw.println("Height: " + this.Height);
            pw.println("ColorCount: " + this.ColorCount);
            pw.println("Reserved: " + this.Reserved);
            pw.println("Planes: " + this.Planes);
            pw.println("BitCount: " + this.BitCount);
            pw.println("ImageSize: " + this.ImageSize);
            pw.println("ImageOffset: " + this.ImageOffset);
        }
    }

    private static class FileHeader {
        public final int reserved;
        public final int iconType;
        public final int iconCount;

        public FileHeader(int reserved, int iconType, int iconCount) {
            this.reserved = reserved;
            this.iconType = iconType;
            this.iconCount = iconCount;
        }

        public void dump(PrintWriter pw) {
            pw.println("FileHeader");
            pw.println("Reserved: " + this.reserved);
            pw.println("IconType: " + this.iconType);
            pw.println("IconCount: " + this.iconCount);
            pw.println();
        }
    }
}

