/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.fieldtypes;

import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.fieldtypes.FieldType;

public class FieldTypeASCII
extends FieldType {
    public FieldTypeASCII(int type, String name) {
        super(type, 1, name);
    }

    @Override
    public Object getSimpleValue(TiffField entry) {
        byte[] bytes = this.getRawBytes(entry);
        return new String(bytes, 0, bytes.length - 1);
    }

    @Override
    public byte[] writeData(Object o, int byteOrder) throws ImageWriteException {
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            byte[] result = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
            result[result.length - 1] = 0;
            return result;
        }
        if (o instanceof String) {
            byte[] bytes = ((String)o).getBytes();
            byte[] result = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
            result[result.length - 1] = 0;
            return result;
        }
        throw new ImageWriteException("Unknown data type: " + o);
    }
}

