/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.client.api.CircularDependencyException;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Beta
public class Project {
    protected final LintClient mClient;
    protected final File mDir;
    protected final File mReferenceDir;
    protected Configuration mConfiguration;
    protected String mPackage;
    protected int mBuildSdk = -1;
    protected IAndroidTarget mTarget;
    protected AndroidVersion mManifestMinSdk = AndroidVersion.DEFAULT;
    protected AndroidVersion mManifestTargetSdk = AndroidVersion.DEFAULT;
    protected boolean mLibrary;
    protected String mName;
    protected String mProguardPath;
    protected boolean mMergeManifests;
    protected SdkInfo mSdkInfo;
    protected List<File> mFiles;
    protected List<File> mProguardFiles;
    protected List<File> mGradleFiles;
    protected List<File> mManifestFiles;
    protected List<File> mJavaSourceFolders;
    protected List<File> mJavaClassFolders;
    protected List<File> mJavaLibraries;
    protected List<File> mTestSourceFolders;
    protected List<File> mResourceFolders;
    protected List<Project> mDirectLibraries;
    protected List<Project> mAllLibraries;
    protected boolean mReportIssues = true;
    protected Boolean mGradleProject;
    protected Boolean mSupportLib;
    protected Boolean mAppCompat;
    private Map<String, String> mSuperClassMap;
    private ResourceVisibilityLookup mResourceVisibility;
    private static Boolean sAospBuild;
    private static AndroidVersion sCurrentVersion;
    private List<String> mCachedApplicableDensities;

    @NonNull
    public static Project create(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir) {
        return new Project(client, dir, referenceDir);
    }

    public boolean isGradleProject() {
        if (this.mGradleProject == null) {
            this.mGradleProject = this.mClient.isGradleProject(this);
        }
        return this.mGradleProject;
    }

    public boolean isAndroidProject() {
        return true;
    }

    @Nullable
    public AndroidProject getGradleProjectModel() {
        return null;
    }

    @Nullable
    public AndroidLibrary getGradleLibraryModel() {
        return null;
    }

    @Nullable
    public Variant getCurrentVariant() {
        return null;
    }

    protected Project(@NonNull LintClient client, @NonNull File dir, @NonNull File referenceDir) {
        this.mClient = client;
        this.mDir = dir;
        this.mReferenceDir = referenceDir;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        block23: {
            try {
                Properties properties = new Properties();
                File propFile = new File(this.mDir, "project.properties");
                if (!propFile.exists()) break block23;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));
                try {
                    String key;
                    String library;
                    properties.load(is);
                    String value = properties.getProperty("android.library");
                    this.mLibrary = "true".equals(value);
                    String proguardPath = properties.getProperty("proguard.config");
                    if (proguardPath != null) {
                        this.mProguardPath = proguardPath;
                    }
                    this.mMergeManifests = "true".equals(properties.getProperty("manifestmerger.enabled"));
                    String target = properties.getProperty("target");
                    if (target != null) {
                        int index = target.lastIndexOf(45);
                        if (index == -1) {
                            index = target.lastIndexOf(58);
                        }
                        if (index != -1) {
                            String versionString = target.substring(index + 1);
                            try {
                                this.mBuildSdk = Integer.parseInt(versionString);
                            }
                            catch (NumberFormatException nufe) {
                                this.mClient.log(Severity.WARNING, null, "Unexpected build target format: %1$s", target);
                            }
                        }
                    }
                    for (int i = 1; i < 1000 && (library = properties.getProperty(key = String.format("android.library.reference.%1$d", i))) != null; ++i) {
                        if (library.isEmpty()) {
                            break;
                        }
                        File libraryDir = new File(this.mDir, library).getCanonicalFile();
                        if (this.mDirectLibraries == null) {
                            this.mDirectLibraries = new ArrayList<Project>();
                        }
                        File libraryReferenceDir = this.mReferenceDir;
                        if (!libraryDir.getPath().startsWith(this.mReferenceDir.getPath())) {
                            libraryReferenceDir = libraryReferenceDir.getCanonicalFile();
                            if (!libraryDir.getPath().startsWith(this.mReferenceDir.getPath())) {
                                for (File file = libraryReferenceDir; file != null && !file.getPath().isEmpty(); file = file.getParentFile()) {
                                    if (!libraryDir.getPath().startsWith(file.getPath())) continue;
                                    libraryReferenceDir = file;
                                    break;
                                }
                            }
                        }
                        try {
                            Project libraryPrj = this.mClient.getProject(libraryDir, libraryReferenceDir);
                            this.mDirectLibraries.add(libraryPrj);
                            libraryPrj.setReportIssues(false);
                            continue;
                        }
                        catch (CircularDependencyException e) {
                            e.setProject(this);
                            e.setLocation(Location.create(propFile));
                            throw e;
                        }
                    }
                }
                finally {
                    try {
                        Closeables.close((Closeable)is, (boolean)true);
                    }
                    catch (IOException e) {}
                }
            }
            catch (IOException ioe) {
                this.mClient.log(ioe, "Initializing project state", new Object[0]);
            }
        }
        this.mDirectLibraries = this.mDirectLibraries != null ? Collections.unmodifiableList(this.mDirectLibraries) : Collections.emptyList();
    }

    public String toString() {
        return "Project [dir=" + this.mDir + ']';
    }

    public int hashCode() {
        return this.mDir.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)obj;
        return this.mDir.equals(other.mDir);
    }

    public void addFile(@NonNull File file) {
        if (this.mFiles == null) {
            this.mFiles = new ArrayList<File>();
        }
        this.mFiles.add(file);
    }

    @Nullable
    public List<File> getSubset() {
        return this.mFiles;
    }

    @NonNull
    public List<File> getJavaSourceFolders() {
        if (this.mJavaSourceFolders == null) {
            if (Project.isAospFrameworksProject(this.mDir)) {
                return Collections.singletonList(new File(this.mDir, "java"));
            }
            if (Project.isAospBuildEnvironment()) {
                String top = Project.getAospTop();
                if (this.mDir.getAbsolutePath().startsWith(top)) {
                    this.mJavaSourceFolders = this.getAospJavaSourcePath();
                    return this.mJavaSourceFolders;
                }
            }
            this.mJavaSourceFolders = this.mClient.getJavaSourceFolders(this);
        }
        return this.mJavaSourceFolders;
    }

    @NonNull
    public List<File> getJavaClassFolders() {
        if (this.mJavaClassFolders == null) {
            String relative;
            File jar;
            File out;
            Object top;
            if (Project.isAospFrameworksProject(this.mDir) && (top = this.mDir.getParentFile().getParentFile().getParentFile()) != null && (out = new File((File)top, "out")).exists() && (jar = new File(out, (relative = "target/common/obj/JAVA_LIBRARIES/framework_intermediates/classes.jar").replace('/', File.separatorChar))).exists()) {
                this.mJavaClassFolders = Collections.singletonList(jar);
                return this.mJavaClassFolders;
            }
            if (Project.isAospBuildEnvironment()) {
                top = Project.getAospTop();
                if (this.mDir.getAbsolutePath().startsWith((String)top)) {
                    this.mJavaClassFolders = this.getAospJavaClassPath();
                    return this.mJavaClassFolders;
                }
            }
            this.mJavaClassFolders = this.mClient.getJavaClassFolders(this);
        }
        return this.mJavaClassFolders;
    }

    @NonNull
    public List<File> getJavaLibraries() {
        if (this.mJavaLibraries == null) {
            this.mJavaLibraries = this.mClient.getJavaLibraries(this);
        }
        return this.mJavaLibraries;
    }

    @NonNull
    public List<File> getTestSourceFolders() {
        if (this.mTestSourceFolders == null) {
            this.mTestSourceFolders = this.mClient.getTestSourceFolders(this);
        }
        return this.mTestSourceFolders;
    }

    @NonNull
    public List<File> getResourceFolders() {
        if (this.mResourceFolders == null) {
            List<File> folders = this.mClient.getResourceFolders(this);
            if (folders.size() == 1 && Project.isAospFrameworksProject(this.mDir)) {
                this.mManifestMinSdk = this.mManifestTargetSdk = new AndroidVersion(23, null);
                File folder = new File(folders.get(0), "res");
                if (!folder.exists()) {
                    folders = Collections.emptyList();
                }
            }
            this.mResourceFolders = folders;
        }
        return this.mResourceFolders;
    }

    @NonNull
    public String getDisplayPath(@NonNull File file) {
        String referencePath;
        String path = file.getPath();
        if (path.startsWith(referencePath = this.mReferenceDir.getPath())) {
            int length = referencePath.length();
            if (path.length() > length && path.charAt(length) == File.separatorChar) {
                ++length;
            }
            return path.substring(length);
        }
        return path;
    }

    @NonNull
    public String getRelativePath(@NonNull File file) {
        String referencePath;
        String path = file.getPath();
        if (path.startsWith(referencePath = this.mDir.getPath())) {
            int length = referencePath.length();
            if (path.length() > length && path.charAt(length) == File.separatorChar) {
                ++length;
            }
            return path.substring(length);
        }
        return path;
    }

    @NonNull
    public File getDir() {
        return this.mDir;
    }

    @NonNull
    public File getReferenceDir() {
        return this.mReferenceDir;
    }

    @NonNull
    public Configuration getConfiguration() {
        if (this.mConfiguration == null) {
            this.mConfiguration = this.mClient.getConfiguration(this);
        }
        return this.mConfiguration;
    }

    @Nullable
    public String getPackage() {
        return this.mPackage;
    }

    @NonNull
    public AndroidVersion getMinSdkVersion() {
        return this.mManifestMinSdk == null ? AndroidVersion.DEFAULT : this.mManifestMinSdk;
    }

    public int getMinSdk() {
        AndroidVersion version = this.getMinSdkVersion();
        return version == AndroidVersion.DEFAULT ? -1 : version.getApiLevel();
    }

    @NonNull
    public AndroidVersion getTargetSdkVersion() {
        return this.mManifestTargetSdk == AndroidVersion.DEFAULT ? this.getMinSdkVersion() : this.mManifestTargetSdk;
    }

    public int getTargetSdk() {
        AndroidVersion version = this.getTargetSdkVersion();
        return version == AndroidVersion.DEFAULT ? -1 : version.getApiLevel();
    }

    public int getBuildSdk() {
        return this.mBuildSdk;
    }

    @Nullable
    public IAndroidTarget getBuildTarget() {
        if (this.mTarget == null) {
            this.mTarget = this.mClient.getCompileTarget(this);
        }
        return this.mTarget;
    }

    public void readManifest(@NonNull Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        this.mPackage = root.getAttribute("package");
        if (this.mPackage != null && this.mPackage.startsWith("android.support.")) {
            this.mReportIssues = false;
        }
        this.mManifestMinSdk = AndroidVersion.DEFAULT;
        this.mManifestTargetSdk = AndroidVersion.DEFAULT;
        NodeList usesSdks = root.getElementsByTagName("uses-sdk");
        if (usesSdks.getLength() > 0) {
            Element element = (Element)usesSdks.item(0);
            String minSdk = null;
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion")) {
                minSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "minSdkVersion");
            }
            if (minSdk != null) {
                IAndroidTarget[] targets = this.mClient.getTargets();
                this.mManifestMinSdk = SdkVersionInfo.getVersion((String)minSdk, (IAndroidTarget[])targets);
            }
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion")) {
                String targetSdk = element.getAttributeNS("http://schemas.android.com/apk/res/android", "targetSdkVersion");
                if (targetSdk != null) {
                    IAndroidTarget[] targets = this.mClient.getTargets();
                    this.mManifestTargetSdk = SdkVersionInfo.getVersion((String)targetSdk, (IAndroidTarget[])targets);
                }
            } else {
                this.mManifestTargetSdk = this.mManifestMinSdk;
            }
        } else if (Project.isAospBuildEnvironment()) {
            this.extractAospMinSdkVersion();
            this.mManifestTargetSdk = this.mManifestMinSdk;
        }
    }

    public boolean isLibrary() {
        return this.mLibrary;
    }

    @NonNull
    public List<Project> getDirectLibraries() {
        return this.mDirectLibraries != null ? this.mDirectLibraries : Collections.emptyList();
    }

    @NonNull
    public List<Project> getAllLibraries() {
        if (this.mAllLibraries == null) {
            if (this.mDirectLibraries.isEmpty()) {
                return this.mDirectLibraries;
            }
            ArrayList<Project> all = new ArrayList<Project>();
            HashSet seen = Sets.newHashSet();
            HashSet path = Sets.newHashSet();
            seen.add(this);
            path.add(this);
            this.addLibraryProjects(all, seen, path);
            this.mAllLibraries = all;
        }
        return this.mAllLibraries;
    }

    private void addLibraryProjects(@NonNull Collection<Project> collection, @NonNull Set<Project> seen, @NonNull Set<Project> path) {
        for (Project library : this.mDirectLibraries) {
            if (seen.contains(library)) {
                if (!path.contains(library)) continue;
                this.mClient.log(Severity.WARNING, null, "Internal lint error: cyclic library dependency for %1$s", library);
                continue;
            }
            collection.add(library);
            seen.add(library);
            path.add(library);
            library.addLibraryProjects(collection, seen, path);
            path.remove(library);
        }
    }

    @NonNull
    public SdkInfo getSdkInfo() {
        if (this.mSdkInfo == null) {
            this.mSdkInfo = this.mClient.getSdkInfo(this);
        }
        return this.mSdkInfo;
    }

    @NonNull
    public List<File> getManifestFiles() {
        if (this.mManifestFiles == null) {
            File manifestFile = new File(this.mDir, "AndroidManifest.xml");
            this.mManifestFiles = manifestFile.exists() ? Collections.singletonList(manifestFile) : Collections.emptyList();
        }
        return this.mManifestFiles;
    }

    @NonNull
    public List<File> getProguardFiles() {
        if (this.mProguardFiles == null) {
            ArrayList<File> files = new ArrayList<File>();
            if (this.mProguardPath != null) {
                Splitter splitter = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)":;"));
                for (String path : splitter.split((CharSequence)this.mProguardPath)) {
                    if (path.contains("${")) continue;
                    File file = new File(path);
                    if (!file.isAbsolute()) {
                        file = new File(this.getDir(), path);
                    }
                    if (!file.exists()) continue;
                    files.add(file);
                }
            }
            if (files.isEmpty()) {
                File file = new File(this.getDir(), "proguard.cfg");
                if (file.exists()) {
                    files.add(file);
                }
                if ((file = new File(this.getDir(), "proguard-project.txt")).exists()) {
                    files.add(file);
                }
            }
            this.mProguardFiles = files;
        }
        return this.mProguardFiles;
    }

    @NonNull
    public List<File> getGradleBuildScripts() {
        if (this.mGradleFiles == null) {
            if (this.isGradleProject()) {
                File settings;
                this.mGradleFiles = Lists.newArrayListWithExpectedSize((int)2);
                File build = new File(this.mDir, "build.gradle");
                if (build.exists()) {
                    this.mGradleFiles.add(build);
                }
                if ((settings = new File(this.mDir, "settings.gradle")).exists()) {
                    this.mGradleFiles.add(settings);
                }
            } else {
                this.mGradleFiles = Collections.emptyList();
            }
        }
        return this.mGradleFiles;
    }

    @NonNull
    public String getName() {
        if (this.mName == null) {
            this.mName = this.mClient.getProjectName(this);
        }
        return this.mName;
    }

    public void setName(@NonNull String name) {
        assert (!name.isEmpty());
        this.mName = name;
    }

    public void setReportIssues(boolean reportIssues) {
        this.mReportIssues = reportIssues;
    }

    public boolean getReportIssues() {
        return this.mReportIssues;
    }

    public boolean isMergingManifests() {
        return this.mMergeManifests;
    }

    private static boolean isAospBuildEnvironment() {
        if (sAospBuild == null) {
            sAospBuild = Project.getAospTop() != null;
        }
        return sAospBuild;
    }

    public static boolean isAospFrameworksProject(@NonNull File dir) {
        if (!dir.getPath().endsWith("core")) {
            return false;
        }
        File parent = dir.getParentFile();
        if (parent == null || !parent.getName().equals("base")) {
            return false;
        }
        return (parent = parent.getParentFile()) != null && parent.getName().equals("frameworks");
    }

    private static String getAospTop() {
        return System.getenv("ANDROID_BUILD_TOP");
    }

    private static String getAospHostOut() {
        return System.getenv("ANDROID_HOST_OUT");
    }

    private static String getAospProductOut() {
        return System.getenv("ANDROID_PRODUCT_OUT");
    }

    private List<File> getAospJavaSourcePath() {
        ArrayList<File> sources = new ArrayList<File>(2);
        File src = new File(this.mDir, "src");
        if (src.exists()) {
            sources.add(src);
        }
        for (File dir : this.getIntermediateDirs()) {
            File classes = new File(dir, "src");
            if (!classes.exists()) continue;
            sources.add(classes);
        }
        if (sources.isEmpty()) {
            this.mClient.log(null, "Warning: Could not find sources or generated sources for project %1$s", this.getName());
        }
        return sources;
    }

    private List<File> getAospJavaClassPath() {
        ArrayList<File> classDirs = new ArrayList<File>(1);
        for (File dir : this.getIntermediateDirs()) {
            File classes = new File(dir, "classes");
            if (classes.exists()) {
                classDirs.add(classes);
                continue;
            }
            classes = new File(dir, "classes.jar");
            if (!classes.exists()) continue;
            classDirs.add(classes);
        }
        if (classDirs.isEmpty()) {
            this.mClient.log(null, "No bytecode found: Has the project been built? (%1$s)", this.getName());
        }
        return classDirs;
    }

    private List<File> getIntermediateDirs() {
        ArrayList<File> intermediates = new ArrayList<File>();
        String moduleName = this.mDir.getName();
        String top = Project.getAospTop();
        String[] outFolders = new String[]{top + "/out/host/common/obj", top + "/out/target/common/obj", Project.getAospHostOut() + "/obj", Project.getAospProductOut() + "/obj"};
        String[] moduleClasses = new String[]{"APPS", "JAVA_LIBRARIES"};
        for (String out : outFolders) {
            assert (new File(out.replace('/', File.separatorChar)).exists()) : out;
            for (String moduleClass : moduleClasses) {
                String path = out + '/' + moduleClass + '/' + moduleName + "_intermediates";
                File file = new File(path.replace('/', File.separatorChar));
                if (!file.exists()) continue;
                intermediates.add(file);
            }
        }
        return intermediates;
    }

    private void extractAospMinSdkVersion() {
        boolean found = false;
        File makefile = new File(this.mDir, "Android.mk");
        if (makefile.exists()) {
            try {
                List lines = Files.readLines((File)makefile, (Charset)Charsets.UTF_8);
                Pattern p = Pattern.compile("LOCAL_SDK_VERSION\\s*:=\\s*(.*)");
                for (String line : lines) {
                    Matcher matcher = p.matcher(line = line.trim());
                    if (!matcher.matches()) continue;
                    found = true;
                    String version = matcher.group(1);
                    this.mManifestMinSdk = version.equals("current") ? Project.findCurrentAospVersion() : SdkVersionInfo.getVersion((String)version, (IAndroidTarget[])this.mClient.getTargets());
                    break;
                }
            }
            catch (IOException ioe) {
                this.mClient.log(ioe, null, new Object[0]);
            }
        }
        if (!found) {
            this.mManifestMinSdk = Project.findCurrentAospVersion();
        }
    }

    private static AndroidVersion findCurrentAospVersion() {
        if (sCurrentVersion == null) {
            File apiDir = new File(Project.getAospTop(), "frameworks/base/api".replace('/', File.separatorChar));
            File[] apiFiles = apiDir.listFiles();
            if (apiFiles == null) {
                sCurrentVersion = AndroidVersion.DEFAULT;
                return sCurrentVersion;
            }
            int max = 1;
            for (File apiFile : apiFiles) {
                String base;
                String name = apiFile.getName();
                int index = name.indexOf(46);
                if (index <= 0 || !Character.isDigit((base = name.substring(0, index)).charAt(0))) continue;
                try {
                    int version = Integer.parseInt(base);
                    if (version <= max) continue;
                    max = version;
                }
                catch (NumberFormatException nufe) {
                    // empty catch block
                }
            }
            sCurrentVersion = new AndroidVersion(max, null);
        }
        return sCurrentVersion;
    }

    @Nullable
    public Boolean dependsOn(@NonNull String artifact) {
        if ("com.android.support:support-v4".equals(artifact)) {
            if (this.mSupportLib == null) {
                for (File file : this.getJavaLibraries()) {
                    String name = file.getName();
                    if (!name.equals("android-support-v4.jar") && !name.startsWith("support-v4-")) continue;
                    this.mSupportLib = true;
                    break;
                }
                if (this.mSupportLib == null) {
                    for (Project dependency : this.getDirectLibraries()) {
                        Boolean b = dependency.dependsOn(artifact);
                        if (b == null || !b.booleanValue()) continue;
                        this.mSupportLib = true;
                        break;
                    }
                }
                if (this.mSupportLib == null) {
                    this.mSupportLib = false;
                }
            }
            return this.mSupportLib;
        }
        if ("com.android.support:appcompat-v7".equals(artifact)) {
            if (this.mAppCompat == null) {
                for (File file : this.getJavaLibraries()) {
                    String name = file.getName();
                    if (!name.startsWith("appcompat-v7-")) continue;
                    this.mAppCompat = true;
                    break;
                }
                if (this.mAppCompat == null) {
                    for (Project dependency : this.getDirectLibraries()) {
                        Boolean b = dependency.dependsOn(artifact);
                        if (b == null || !b.booleanValue()) continue;
                        this.mAppCompat = true;
                        break;
                    }
                }
                if (this.mAppCompat == null) {
                    this.mAppCompat = false;
                }
            }
            return this.mAppCompat;
        }
        return null;
    }

    @Nullable
    public List<String> getApplicableDensities() {
        if (this.mCachedApplicableDensities == null) {
            if (this.isGradleProject() && this.getGradleProjectModel() != null && this.getCurrentVariant() != null) {
                HashSet relevantDensities = Sets.newHashSet();
                Variant variant = this.getCurrentVariant();
                List variantFlavors = variant.getProductFlavors();
                AndroidProject gradleProjectModel = this.getGradleProjectModel();
                Project.addResConfigsFromFlavor(relevantDensities, null, this.getGradleProjectModel().getDefaultConfig());
                for (ProductFlavorContainer container : gradleProjectModel.getProductFlavors()) {
                    Project.addResConfigsFromFlavor(relevantDensities, variantFlavors, container);
                }
                if (relevantDensities.isEmpty()) {
                    AndroidArtifact mainArtifact = variant.getMainArtifact();
                    Collection outputs = mainArtifact.getOutputs();
                    for (AndroidArtifactOutput output : outputs) {
                        for (OutputFile file : output.getOutputs()) {
                            String DENSITY_NAME = OutputFile.FilterType.DENSITY.name();
                            if (!file.getFilterTypes().contains(DENSITY_NAME)) continue;
                            for (FilterData data : file.getFilters()) {
                                if (!DENSITY_NAME.equals(data.getFilterType())) continue;
                                relevantDensities.add(data.getIdentifier());
                            }
                        }
                    }
                }
                if (!relevantDensities.isEmpty()) {
                    this.mCachedApplicableDensities = Lists.newArrayListWithExpectedSize((int)10);
                    for (String density : relevantDensities) {
                        String folder = ResourceFolderType.DRAWABLE.getName() + '-' + density;
                        this.mCachedApplicableDensities.add(folder);
                    }
                    Collections.sort(this.mCachedApplicableDensities);
                } else {
                    this.mCachedApplicableDensities = Collections.emptyList();
                }
            } else {
                this.mCachedApplicableDensities = Collections.emptyList();
            }
        }
        return this.mCachedApplicableDensities.isEmpty() ? null : this.mCachedApplicableDensities;
    }

    @NonNull
    public Map<String, String> getSuperClassMap() {
        if (this.mSuperClassMap == null) {
            this.mSuperClassMap = this.mClient.createSuperClassMap(this);
        }
        return this.mSuperClassMap;
    }

    private static void addResConfigsFromFlavor(@NonNull Set<String> relevantDensities, @Nullable List<String> variantFlavors, @NonNull ProductFlavorContainer container) {
        ProductFlavor flavor = container.getProductFlavor();
        if ((variantFlavors == null || variantFlavors.contains(flavor.getName())) && !flavor.getResourceConfigurations().isEmpty()) {
            for (String densityName : flavor.getResourceConfigurations()) {
                Density density = Density.getEnum((String)densityName);
                if (density == null || !density.isRecommended() || density == Density.NODPI || density == Density.ANYDPI) continue;
                relevantDensities.add(densityName);
            }
        }
    }

    @NonNull
    public ResourceVisibilityLookup getResourceVisibility() {
        if (this.mResourceVisibility == null) {
            if (this.isGradleProject()) {
                AndroidProject project = this.getGradleProjectModel();
                Variant variant = this.getCurrentVariant();
                if (project != null && variant != null) {
                    this.mResourceVisibility = this.mClient.getResourceVisibilityProvider().get(project, variant);
                } else if (this.getGradleLibraryModel() != null) {
                    try {
                        this.mResourceVisibility = this.mClient.getResourceVisibilityProvider().get(this.getGradleLibraryModel());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (this.mResourceVisibility == null) {
                this.mResourceVisibility = ResourceVisibilityLookup.NONE;
            }
        }
        return this.mResourceVisibility;
    }

    @NonNull
    public LintClient getClient() {
        return this.mClient;
    }

    @Nullable
    public IAndroidTarget getCompileTarget() {
        return this.mClient.getCompileTarget(this);
    }
}

