/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.model.ManifestInfo;
import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;

public class AndroidPsiUtils {
    public static PsiFile getPsiFileSafely(final Project project, final VirtualFile file) {
        return (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                return file.isValid() ? PsiManager.getInstance((Project)project).findFile(file) : null;
            }
        });
    }

    public static Module getModuleSafely(final PsiElement element) {
        return (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            }
        });
    }

    public static Module getModuleSafely(final Project project, final VirtualFile file) {
        return (Module)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module>(){

            public Module compute() {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                return psiFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            }
        });
    }

    public static XmlTag getRootTagSafely(final XmlFile file) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return file.getRootTag();
        }
        return (XmlTag)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XmlTag>(){

            public XmlTag compute() {
                return file.getRootTag();
            }
        });
    }

    public static String getRootTagAttributeSafely(final XmlFile file, final String attribute, final String namespace) {
        Application application = ApplicationManager.getApplication();
        if (!application.isReadAccessAllowed()) {
            return (String)application.runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return AndroidPsiUtils.getRootTagAttributeSafely(file, attribute, namespace);
                }
            });
        }
        XmlTag tag = file.getRootTag();
        if (tag != null) {
            XmlAttribute attr;
            XmlAttribute xmlAttribute = attr = namespace != null ? tag.getAttribute(attribute, namespace) : tag.getAttribute(attribute);
            if (attr != null) {
                return attr.getValue();
            }
        }
        return null;
    }

    public static PsiDirectory getPsiDirectorySafely(final Project project, final VirtualFile dir) {
        return (PsiDirectory)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiDirectory>(){

            public PsiDirectory compute() {
                return PsiManager.getInstance((Project)project).findDirectory(dir);
            }
        });
    }

    public static String getRootTagName(PsiFile file) {
        if (ResourceHelper.getFolderType(file) == ResourceFolderType.XML && file instanceof XmlFile) {
            XmlTag rootTag = AndroidPsiUtils.getRootTagSafely((XmlFile)file);
            return rootTag == null ? null : rootTag.getName();
        }
        return null;
    }

    public static boolean isResourceReference(PsiElement element) {
        return AndroidPsiUtils.getResourceReferenceType(element) != ResourceReferenceType.NONE;
    }

    public static ResourceReferenceType getResourceReferenceType(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element);
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiReferenceExpression) {
            return AndroidPsiUtils.getResourceReferenceType((PsiReferenceExpression)element.getParent());
        }
        return ResourceReferenceType.NONE;
    }

    public static String getResourceName(PsiElement element) {
        PsiReferenceExpression refExp;
        String name;
        assert (AndroidPsiUtils.isResourceReference(element));
        if (element instanceof PsiReferenceExpression && (name = (refExp = (PsiReferenceExpression)element).getReferenceName()) != null) {
            return name;
        }
        return element.getText();
    }

    public static ResourceReferenceType getResourceReferenceType(PsiReferenceExpression element) {
        PsiExpression exp = element.getQualifierExpression();
        if (!(exp instanceof PsiReferenceExpression)) {
            return ResourceReferenceType.NONE;
        }
        if (!((exp = ((PsiReferenceExpression)exp).getQualifierExpression()) instanceof PsiReferenceExpression)) {
            return ResourceReferenceType.NONE;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)exp;
        if ("R".equals(ref.getReferenceName())) {
            PsiExpression qualifierExpression = ref.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)qualifierExpression).getReferenceName())) {
                return ResourceReferenceType.FRAMEWORK;
            }
            return ResourceReferenceType.APP;
        }
        return ResourceReferenceType.NONE;
    }

    public static ResourceType getResourceType(PsiElement resourceRefElement) {
        if (!AndroidPsiUtils.isResourceReference(resourceRefElement)) {
            return null;
        }
        PsiReferenceExpression exp = resourceRefElement instanceof PsiReferenceExpression ? (PsiReferenceExpression)resourceRefElement : (PsiReferenceExpression)resourceRefElement.getParent();
        PsiExpression qualifierExpression = exp.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        return ResourceType.getEnum((String)qualifierExpression.getLastChild().getText());
    }

    public static String getDeclaredContextFqcn(Module module, XmlFile xmlFile) {
        String context = AndroidPsiUtils.getRootTagAttributeSafely(xmlFile, "context", "http://schemas.android.com/tools");
        if (context != null && !context.isEmpty()) {
            boolean startsWithDot;
            boolean bl = startsWithDot = context.charAt(0) == '.';
            if (startsWithDot || context.indexOf(46) == -1) {
                String pkg = ManifestInfo.get(module, false).getPackage();
                return startsWithDot ? pkg + context : pkg + '.' + context;
            }
        }
        return null;
    }

    public static PsiClass getContextClass(Module module, XmlFile xmlFile) {
        String fqn = AndroidPsiUtils.getDeclaredContextFqcn(module, xmlFile);
        if (fqn != null) {
            Project project = module.getProject();
            return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        }
        return null;
    }

    public static String getQualifiedNameSafely(final PsiClass psiClass) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return psiClass.getQualifiedName();
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return psiClass.getQualifiedName();
            }
        });
    }

    public static String getAttributeSafely(final XmlTag tag, final String namespace, final String name) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return tag.getAttributeValue(name, namespace);
        }
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return tag.getAttributeValue(name, namespace);
            }
        });
    }

    public static enum ResourceReferenceType {
        NONE,
        APP,
        FRAMEWORK;

    }
}

