/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public class AndroidStudioActionRemover
extends AnAction {
    protected final AnAction myDelegate;

    public AndroidStudioActionRemover(AnAction delegate, String backupText) {
        super(delegate.getTemplatePresentation().getTextWithMnemonic(), delegate.getTemplatePresentation().getDescription(), delegate.getTemplatePresentation().getIcon());
        this.myDelegate = delegate;
        Presentation presentation = this.getTemplatePresentation();
        if (StringUtil.isEmpty((String)presentation.getText())) {
            presentation.setText(backupText);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        this.myDelegate.actionPerformed(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null && Projects.requiresAndroidModel(project)) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        this.copyTextAndIcon(this.getTemplatePresentation(), this.myDelegate.getTemplatePresentation());
        this.myDelegate.update(e);
    }

    protected void copyTextAndIcon(Presentation source, Presentation destination) {
        destination.setText(source.getTextWithMnemonic());
        destination.setIcon(source.getIcon());
    }
}

