/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.internal.avd.AvdInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public abstract class AvdUiAction
implements Action,
HyperlinkListener {
    protected final AvdInfoProvider myAvdInfoProvider;
    private final String myText;
    private final String myDescription;
    private final Icon myIcon;
    private Map<String, Object> myData = Maps.newHashMap();

    public AvdUiAction(AvdInfoProvider avdInfoProvider, String text, String description, Icon icon) {
        this.myAvdInfoProvider = avdInfoProvider;
        this.myText = text;
        this.myIcon = icon;
        this.myDescription = description;
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("Name", text);
    }

    @Override
    public Object getValue(String key) {
        return this.myData.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        this.myData.put(key, value);
    }

    @Override
    @Deprecated
    public void setEnabled(boolean b) {
    }

    @Override
    public abstract boolean isEnabled();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getText() {
        return this.myText;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    protected AvdInfo getAvdInfo() {
        return this.myAvdInfoProvider.getAvdInfo();
    }

    protected void refreshAvds() {
        this.myAvdInfoProvider.refreshAvds();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        this.actionPerformed(null);
    }

    public static interface AvdInfoProvider {
        public AvdInfo getAvdInfo();

        public void refreshAvds();

        public void notifyRun();

        public Project getProject();

        public JComponent getComponent();
    }
}

