/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.TaskExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseDataReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.concurrent.Future;

public class EmulatorProcessHandler
extends ProcessHandler
implements TaskExecutor {
    private static final Logger LOG = Logger.getInstance(EmulatorProcessHandler.class);
    private final Process myProcess;

    public EmulatorProcessHandler(Process process) {
        this.myProcess = process;
    }

    public void startNotify() {
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                try {
                    final EmulatorOutputReader stdoutReader = new EmulatorOutputReader(EmulatorProcessHandler.this.myProcess.getInputStream(), ProcessOutputTypes.STDOUT);
                    final EmulatorOutputReader stderrReader = new EmulatorOutputReader(EmulatorProcessHandler.this.myProcess.getErrorStream(), ProcessOutputTypes.STDERR);
                    EmulatorProcessHandler.this.executeTask(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                stderrReader.waitFor();
                                stdoutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                EmulatorProcessHandler.this.notifyProcessTerminated(0);
                            }
                        }
                    });
                }
                finally {
                    EmulatorProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.notifyProcessTerminated(0);
        }
    }

    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                EmulatorProcessHandler.this.closeStreams();
                EmulatorProcessHandler.this.notifyProcessDetached();
            }
        };
        this.executeTask(runnable);
    }

    public boolean detachIsDefault() {
        return true;
    }

    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    public boolean isSilentlyDestroyOnClose() {
        return true;
    }

    private void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public Future<?> executeTask(Runnable task) {
        return ApplicationManager.getApplication().executeOnPooledThread(task);
    }

    private class EmulatorOutputReader
    extends BaseDataReader {
        private final BufferedReader myBufferedReader;
        private final Key myProcessOutputType;

        private EmulatorOutputReader(InputStream stream, Key processOutputType) {
            super(BaseDataReader.SleepingPolicy.SIMPLE);
            this.myBufferedReader = new BufferedReader(new InputStreamReader(stream));
            this.myProcessOutputType = processOutputType;
            this.start();
        }

        protected Future<?> executeOnPooledThread(Runnable runnable) {
            return EmulatorProcessHandler.this.executeTask(runnable);
        }

        protected boolean readAvailable() throws IOException {
            String line = this.myBufferedReader.readLine();
            if (line == null) {
                this.stop();
                return false;
            }
            if (line.isEmpty()) {
                return false;
            }
            EmulatorProcessHandler.this.notifyTextAvailable(line + "\n", this.myProcessOutputType);
            return true;
        }

        protected void close() throws IOException {
            this.myBufferedReader.close();
        }
    }
}

