/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Abi;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.welcome.install.ComponentInstaller;
import com.android.tools.idea.welcome.install.Haxm;
import com.android.tools.idea.welcome.install.InstallComponentsOperation;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallOperation;
import com.android.tools.idea.welcome.install.InstallationCancelledException;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizard;
import com.android.tools.idea.wizard.dynamic.DynamicWizardHost;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.View;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class HaxmAlert
extends JPanel {
    private JBLabel myWarningMessage;
    private HyperlinkLabel myErrorInstructionsLink = new HyperlinkLabel();
    private HyperlinkListener myErrorLinkListener;
    SystemImageDescription myImageDescription;
    private static final IdDisplay GOOGLE_APIS_TAG = new IdDisplay("google_apis", "");
    private static HaxmState ourHaxmState = HaxmState.NOT_INITIALIZED;

    public HaxmAlert() {
        this.myWarningMessage = new JBLabel(){

            public Dimension getPreferredSize() {
                View view = (View)this.getClientProperty("html");
                Container parent = this.getParent();
                if (view != null && parent != null && parent.getWidth() > 0) {
                    view.setSize(parent.getWidth(), 0.0f);
                    return new Dimension((int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                }
                return super.getPreferredSize();
            }
        };
        this.setLayout((LayoutManager)new GridLayoutManager(2, 1));
        GridConstraints constraints = new GridConstraints();
        constraints.setAnchor(8);
        this.add((Component)this.myWarningMessage, constraints);
        constraints.setRow(1);
        this.add((Component)this.myErrorInstructionsLink, constraints);
        this.myErrorInstructionsLink.setOpaque(false);
        this.myWarningMessage.setForeground((Color)JBColor.RED);
        this.myWarningMessage.setHorizontalAlignment(2);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Recommendation"), BorderFactory.createEmptyBorder(0, 5, 3, 5)));
    }

    public void setSystemImageDescription(SystemImageDescription description) {
        this.myImageDescription = description;
        this.refresh();
    }

    private void refresh() {
        String warningText;
        if (this.myImageDescription == null) {
            this.setVisible(false);
            return;
        }
        boolean hasLink = false;
        StringBuilder warningTextBuilder = new StringBuilder();
        if (this.isIntel()) {
            if (!this.myImageDescription.getAbiType().startsWith(Abi.X86.toString())) {
                warningTextBuilder.append("Consider using an x86 system image for better emulation performance.<br>");
            } else {
                HaxmState haxmState = HaxmAlert.getHaxmState(false);
                if (haxmState == HaxmState.NOT_INSTALLED) {
                    if (SystemInfo.isLinux) {
                        warningTextBuilder.append("Enable Linux KVM for better emulation performance.<br>");
                        this.myErrorInstructionsLink.setHyperlinkTarget("https://software.intel.com/blogs/2012/03/12/how-to-start-intel-hardware-assisted-virtualization-hypervisor-on-linux-to-speed-up-intel-android-x86-emulator");
                        this.myErrorInstructionsLink.setHtmlText("<a>KVM Instructions</a>");
                        if (this.myErrorLinkListener != null) {
                            this.myErrorInstructionsLink.removeHyperlinkListener(this.myErrorLinkListener);
                        }
                        hasLink = true;
                    } else if (Haxm.canRun()) {
                        warningTextBuilder.append("Install Intel HAXM for better emulation performance.<br>");
                        this.setupDownloadLink();
                        hasLink = true;
                    }
                } else if (haxmState == HaxmState.NOT_LATEST) {
                    warningTextBuilder.append("Newer HAXM Version Available<br>");
                    this.setupDownloadLink();
                    hasLink = true;
                }
            }
        }
        if (this.myImageDescription.getVersion().getApiLevel() < 8) {
            warningTextBuilder.append("This API Level is Deprecated<br>");
        }
        if (!GOOGLE_APIS_TAG.equals((Object)this.myImageDescription.getTag())) {
            warningTextBuilder.append("Consider using a system image with Google APIs to enable testing with Google Play Services.");
        }
        if (!(warningText = warningTextBuilder.toString()).isEmpty()) {
            warningTextBuilder.insert(0, "<html>");
            warningTextBuilder.append("</html>");
            this.myWarningMessage.setText(warningTextBuilder.toString());
            this.setVisible(true);
            this.myErrorInstructionsLink.setVisible(hasLink);
        } else {
            this.setVisible(false);
        }
    }

    private void setupDownloadLink() {
        this.myErrorInstructionsLink.setHyperlinkTarget(null);
        this.myErrorInstructionsLink.setHtmlText("<a>Download and install HAXM<a>");
        if (this.myErrorLinkListener != null) {
            this.myErrorInstructionsLink.removeHyperlinkListener(this.myErrorLinkListener);
        }
        this.myErrorLinkListener = new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                HaxmWizard wizard = new HaxmWizard();
                wizard.init();
                wizard.show();
                HaxmAlert.getHaxmState(true);
                HaxmAlert.this.refresh();
            }
        };
        this.myErrorInstructionsLink.addHyperlinkListener(this.myErrorLinkListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isIntel() {
        block10: {
            if (SystemInfo.isMac) {
                return true;
            }
            if (!SystemInfo.isLinux) ** GOTO lbl9
            br = null;
            try {
                block11: {
                    br = new BufferedReader(new FileReader("/proc/cpuinfo"));
                    line = br.readLine();
                    break block11;
lbl9:
                    // 1 sources

                    if (SystemInfo.isWindows == false) return false;
                    id = System.getenv().get("PROCESSOR_IDENTIFIER");
                    if (id == null) return false;
                    if (id.contains("GenuineIntel") == false) return false;
                    return true;
                }
                while (br.ready()) {
                    if (line.startsWith("vendor_id") && line.endsWith("GenuineIntel")) {
                        var3_6 = true;
                        break block10;
                    }
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                Logger.getInstance(this.getClass()).warn("/proc/cpuinfo not found, assuming non-intel CPU");
                var3_7 = false;
                {
                    catch (Throwable var4_9) {
                        Closeables.closeQuietly(br);
                        throw var4_9;
                    }
                }
                Closeables.closeQuietly((Reader)br);
                return var3_7;
                catch (IOException e) {
                    Logger.getInstance(this.getClass()).warn("Error reading /proc/cpuinfo, assuming non-intel CPU");
                    var3_8 = false;
                    Closeables.closeQuietly((Reader)br);
                    return var3_8;
                }
            }
            Closeables.closeQuietly((Reader)br);
            return false;
        }
        Closeables.closeQuietly((Reader)br);
        return var3_6;
    }

    private static HaxmState getHaxmState(boolean forceRefresh) {
        if (ourHaxmState == HaxmState.NOT_INITIALIZED || forceRefresh) {
            ourHaxmState = HaxmAlert.computeHaxmState();
        }
        return ourHaxmState;
    }

    private static HaxmState computeHaxmState() {
        boolean found;
        block11: {
            found = false;
            try {
                if (SystemInfo.isMac) {
                    Pattern pattern;
                    Matcher matcher;
                    String output = ExecUtil.execAndReadLine((String[])new String[]{"/usr/sbin/kextstat", "-l", "-b", "com.intel.kext.intelhaxm"});
                    if (output != null && !output.isEmpty() && (matcher = (pattern = Pattern.compile("com\\.intel\\.kext\\.intelhaxm( \\((.+)\\))?")).matcher(output)).find()) {
                        found = true;
                    }
                    break block11;
                }
                if (SystemInfo.isWindows) {
                    ProcessOutput processOutput = ExecUtil.execAndGetOutput((List)ImmutableList.of((Object)"sc", (Object)"query", (Object)"intelhaxm"), null);
                    found = Iterables.all((Iterable)processOutput.getStdoutLines(), (Predicate)new Predicate<String>(){

                        public boolean apply(String input) {
                            return input == null || !input.contains("does not exist");
                        }
                    });
                    break block11;
                }
                if (SystemInfo.isUnix) {
                    File kvm = new File("/dev/kvm");
                    return kvm.exists() ? HaxmState.INSTALLED : HaxmState.NOT_INSTALLED;
                }
                assert (!SystemInfo.isLinux);
                return HaxmState.NOT_INSTALLED;
            }
            catch (ExecutionException e) {
                return HaxmState.NOT_INSTALLED;
            }
        }
        if (found) {
            try {
                FullRevision revision = Haxm.getInstalledVersion(AndroidSdkUtils.tryToChooseAndroidSdk().getLocation());
                FullRevision current = new FullRevision(1, 1, 1);
                if (revision.compareTo(current) < 0) {
                    return HaxmState.NOT_LATEST;
                }
            }
            catch (WizardException e) {
                return HaxmState.NOT_INSTALLED;
            }
            return HaxmState.INSTALLED;
        }
        return HaxmState.NOT_INSTALLED;
    }

    private static class SetupProgressStep
    extends ProgressStep {
        private Haxm myHaxm;
        private final AtomicBoolean myIsBusy = new AtomicBoolean(false);
        private DynamicWizardHost myHost;

        public SetupProgressStep(Disposable parentDisposable, Haxm haxm, DynamicWizardHost host) {
            super(parentDisposable);
            this.myHaxm = haxm;
            this.myHost = host;
        }

        @Override
        public boolean canGoNext() {
            return false;
        }

        @Override
        protected void execute() {
            this.myIsBusy.set(true);
            this.myHost.runSensitiveOperation(this.getProgressIndicator(), true, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SetupProgressStep.this.setupHaxm();
                    }
                    catch (Exception e) {
                        Logger.getInstance(this.getClass()).error((Throwable)e);
                        SetupProgressStep.this.showConsole();
                        SetupProgressStep.this.print(e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                    finally {
                        SetupProgressStep.this.myIsBusy.set(false);
                    }
                }
            });
        }

        @Override
        public boolean canGoPrevious() {
            return false;
        }

        private void setupHaxm() throws IOException {
            final InstallContext installContext = new InstallContext(FileUtil.createTempDirectory((String)"AndroidStudio", (String)"Haxm", (boolean)true), this);
            File destination = AndroidSdkUtils.tryToChooseAndroidSdk().getLocation();
            ArrayList selectedComponents = Lists.newArrayList((Object[])new Haxm[]{this.myHaxm});
            installContext.print("Looking for SDK updates...\n", ConsoleViewContentType.NORMAL_OUTPUT);
            InstallComponentsOperation install = new InstallComponentsOperation(installContext, selectedComponents, new ComponentInstaller(null, true), 0.5);
            try {
                install.then(InstallOperation.wrap(installContext, new Function<File, File>(){

                    public File apply(File input) {
                        SetupProgressStep.this.myHaxm.configure(installContext, input);
                        return input;
                    }
                }, 0.5)).execute(destination);
            }
            catch (InstallationCancelledException e) {
                installContext.print("Android Studio setup was canceled", ConsoleViewContentType.ERROR_OUTPUT);
            }
            catch (WizardException e) {
                throw new RuntimeException(e);
            }
            installContext.print("Done", ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private class HaxmWizard
    extends DynamicWizard {
        public HaxmWizard() {
            super(null, null, "HAXM");
            HaxmPath path = new HaxmPath(this.myHost);
            this.addPath(path);
        }

        @Override
        public void performFinishingActions() {
        }

        @Override
        protected String getProgressTitle() {
            return "Finishing install...";
        }

        @Override
        protected String getWizardActionDescription() {
            return "HAXM Installation";
        }
    }

    private class HaxmPath
    extends DynamicWizardPath {
        DynamicWizardHost myHost;

        public HaxmPath(DynamicWizardHost host) {
            this.myHost = host;
        }

        @Override
        protected void init() {
            ScopedStateStore.Key<Boolean> canShow = ScopedStateStore.createKey("ShowHaxmSteps", ScopedStateStore.Scope.PATH, Boolean.class);
            this.myState.put(canShow, true);
            Haxm haxm = new Haxm(this.getState(), canShow);
            for (IPkgDesc desc : haxm.getRequiredSdkPackages(null)) {
                this.myState.listPush(WizardConstants.INSTALL_REQUESTS_KEY, desc);
            }
            for (DynamicWizardStep step : haxm.createSteps()) {
                this.addStep(step);
            }
            this.addStep(new LicenseAgreementStep(this.getWizard().getDisposable()));
            SetupProgressStep progressStep = new SetupProgressStep(this.getWizard().getDisposable(), haxm, this.myHost);
            this.addStep(progressStep);
            haxm.init(progressStep);
        }

        @Override
        public String getPathName() {
            return "Haxm Path";
        }

        @Override
        public boolean performFinishingActions() {
            return false;
        }
    }

    static enum HaxmState {
        NOT_INITIALIZED,
        INSTALLED,
        NOT_INSTALLED,
        NOT_LATEST;

    }
}

