/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;

public class StorageField
extends JPanel {
    public static final Storage.Unit DEFAULT_UNIT = Storage.Unit.MiB;
    private final ComboBoxModel unitModel = new EnumComboBoxModel(Storage.Unit.class);
    private final ComboBox myUnitsCombo = new ComboBox(this.unitModel);
    private final JTextField myValueField = new JTextField();
    private static final LineBorder ERROR_BORDER = new LineBorder((Color)JBColor.RED);
    private final Border myBorder;
    private long myBytes = 0L;
    private Storage.Unit myCurrentUnit = DEFAULT_UNIT;
    private boolean myIgnoreUpdates;
    private final ScopedDataBinder.ComponentBinding<Storage, StorageField> myBinding = new ScopedDataBinder.ComponentBinding<Storage, StorageField>(){

        @Override
        public void setValue(Storage newValue, StorageField component) {
            if (newValue != null) {
                Storage.Unit unit = newValue.getAppropriateUnits();
                String newText = Long.toString(newValue.getSizeAsUnit(unit));
                if (!component.myValueField.getText().equals(newText)) {
                    component.myValueField.setText(newText);
                }
                component.myUnitsCombo.setSelectedItem((Object)unit);
                StorageField.this.myBytes = newValue.getSize();
                StorageField.this.myCurrentUnit = unit;
            }
        }

        @Override
        public Storage getValue(StorageField component) {
            StorageField.this.updateBytes();
            return StorageField.this.getCurrentValue();
        }

        @Override
        public void addItemListener(ItemListener listener, StorageField component) {
            component.myUnitsCombo.addItemListener(listener);
        }

        @Override
        public Document getDocument(StorageField component) {
            return component.myValueField.getDocument();
        }
    };

    public StorageField() {
        this.setLayout(new BorderLayout(3, 0));
        this.add((Component)this.myValueField, "Center");
        this.add((Component)this.myUnitsCombo, "East");
        this.myUnitsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Storage.Unit>(){

            protected void customizeCellRenderer(JList list, Storage.Unit value, int index, boolean selected, boolean hasFocus) {
                this.append(value.getDisplayValue());
            }
        });
        this.myUnitsCombo.setSelectedItem((Object)DEFAULT_UNIT);
        ItemListener unitChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StorageField.this.myCurrentUnit = (Storage.Unit)StorageField.this.myUnitsCombo.getSelectedItem();
                Storage value = new Storage(StorageField.this.myBytes);
                StorageField.this.myIgnoreUpdates = true;
                StorageField.this.myValueField.setText(Long.toString(value.getSizeAsUnit(StorageField.this.myCurrentUnit)));
                StorageField.this.myIgnoreUpdates = false;
            }
        };
        this.myUnitsCombo.addItemListener(unitChangeListener);
        this.myBorder = this.myValueField.getBorder();
    }

    private void updateBytes() {
        if (this.myIgnoreUpdates) {
            return;
        }
        String text = this.myValueField.getText();
        this.myBytes = 0L;
        if (text != null) {
            try {
                Long valueAsUnits = Long.parseLong(text);
                Storage value = new Storage(valueAsUnits.longValue(), this.myCurrentUnit);
                this.myBytes = value.getSize();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private Storage getCurrentValue() {
        if (this.myBytes <= 0L) {
            return null;
        }
        return new Storage(this.myBytes);
    }

    public ScopedDataBinder.ComponentBinding<Storage, StorageField> getBinding() {
        return this.myBinding;
    }

    public void setError(boolean hasError) {
        if (hasError) {
            this.myValueField.setBorder(ERROR_BORDER);
        } else {
            this.myValueField.setBorder(this.myBorder);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myUnitsCombo.setEnabled(enabled);
        this.myValueField.setEnabled(enabled);
    }
}

