/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.Locale;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;

@Tag(value="config")
public class ConfigurationProjectState {
    private String myLocale;
    private String myTarget;
    private boolean myPickTarget = true;
    private List<String> myDeviceIds = new ArrayList<String>();

    @Property(surroundWithTag=false)
    @Tag(value="devices")
    @AbstractCollection(surroundWithTag=false, elementTag="device", elementValueAttribute="id")
    public List<String> getDeviceIds() {
        return this.myDeviceIds;
    }

    public void setDeviceIds(List<String> deviceIds) {
        this.myDeviceIds = deviceIds;
    }

    @Tag(value="locale")
    public String getLocale() {
        return this.myLocale;
    }

    public void setLocale(String locale) {
        this.myLocale = locale;
    }

    @Tag(value="target")
    public String getTarget() {
        return this.myTarget;
    }

    public void setTarget(String target) {
        this.myTarget = target;
    }

    @Tag(value="pickBest")
    public boolean isPickTarget() {
        return this.myPickTarget;
    }

    public void setPickTarget(boolean pickTarget) {
        this.myPickTarget = pickTarget;
    }

    static IAndroidTarget fromTargetString(ConfigurationManager manager, String targetString) {
        if (targetString != null) {
            for (IAndroidTarget target : manager.getTargets()) {
                if (!targetString.equals(target.hashString()) || !ConfigurationManager.isLayoutLibTarget(target)) continue;
                return target;
            }
        }
        return null;
    }

    static Locale fromLocaleString(String locale) {
        if (locale == null) {
            return Locale.ANY;
        }
        return Locale.create(locale);
    }

    static String toLocaleString(Locale locale) {
        if (locale == null || locale == Locale.ANY) {
            return null;
        }
        return locale.qualifier.getFolderSegment();
    }

    static String toTargetString(IAndroidTarget target) {
        return target != null ? target.hashString() : null;
    }
}

