/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ActivityMenuAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationMenuAction;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.OrientationMenuAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.configurations.ThemeMenuAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.uipreview.AndroidLayoutPreviewToolWindowForm;

public class ConfigurationToolBar
extends JPanel {
    private final AndroidLayoutPreviewToolWindowForm myPreviewWindow;

    public ConfigurationToolBar(AndroidLayoutPreviewToolWindowForm previewWindow) {
        this.myPreviewWindow = previewWindow;
        DefaultActionGroup group = ConfigurationToolBar.createActions(this.myPreviewWindow);
        ActionToolbar toolbar = ConfigurationToolBar.createToolBar((ActionGroup)group);
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar.getComponent(), "Center");
    }

    private static ActionToolbar createToolBar(ActionGroup group) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar toolbar = actionManager.createActionToolbar("LayoutConfiguration", group, true);
        toolbar.setLayoutPolicy(2);
        toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)22, (int)24));
        return toolbar;
    }

    public static DefaultActionGroup createActions(RenderContext configurationHolder) {
        DefaultActionGroup group = new DefaultActionGroup();
        ConfigurationMenuAction configAction = new ConfigurationMenuAction(configurationHolder);
        group.add((AnAction)configAction);
        group.addSeparator();
        DeviceMenuAction deviceAction = new DeviceMenuAction(configurationHolder);
        group.add((AnAction)deviceAction);
        group.addSeparator();
        OrientationMenuAction orientationAction = new OrientationMenuAction(configurationHolder);
        group.add((AnAction)orientationAction);
        group.addSeparator();
        ThemeMenuAction themeAction = new ThemeMenuAction(configurationHolder);
        group.add((AnAction)themeAction);
        group.addSeparator();
        ActivityMenuAction activityAction = new ActivityMenuAction(configurationHolder);
        group.add((AnAction)activityAction);
        group.addSeparator();
        LocaleMenuAction localeAction = new LocaleMenuAction(configurationHolder);
        group.add((AnAction)localeAction);
        group.addSeparator();
        TargetMenuAction targetMenuAction = new TargetMenuAction(configurationHolder);
        group.add((AnAction)targetMenuAction);
        return group;
    }

    public PsiFile getFile() {
        return this.myPreviewWindow.getFile();
    }

    AndroidPlatform getPlatform() {
        PsiFile file = this.getFile();
        return file != null ? ConfigurationToolBar.getPlatform(file) : null;
    }

    private static AndroidPlatform getPlatform(PsiFile file) {
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return module != null ? AndroidPlatform.getInstance(module) : null;
    }

    public Configuration getConfiguration() {
        return this.myPreviewWindow.getConfiguration();
    }
}

