/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.configurations.RenderContext;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class OrientationMenuAction
extends FlatComboAction {
    private final RenderContext myRenderContext;
    private final boolean myClassicStyle;

    public OrientationMenuAction(RenderContext renderContext) {
        this(renderContext, !RenderService.NELE_ENABLED);
    }

    public OrientationMenuAction(RenderContext renderContext, boolean classicStyle) {
        this.myRenderContext = renderContext;
        this.myClassicStyle = classicStyle;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("Go to next state");
        this.updatePresentation(presentation);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        State flip;
        State current;
        if (!this.myClassicStyle) {
            presentation.setIcon(AndroidIcons.NeleIcons.Rotate);
            return;
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (current = configuration.getDeviceState()) != null && (flip = configuration.getNextDeviceState(current)) != null) {
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(flip);
            presentation.setIcon(OrientationMenuAction.getOrientationIcon(orientation, true));
        }
    }

    @Override
    protected boolean handleIconClicked() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return false;
        }
        State current = configuration.getDeviceState();
        State flip = configuration.getNextDeviceState(current);
        if (flip != null) {
            SetDeviceStateAction action = new SetDeviceStateAction(this.myRenderContext, flip.getName(), flip, false, false);
            action.perform();
        }
        return true;
    }

    @Override
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getDevice();
            State current = configuration.getDeviceState();
            if (device != null) {
                List states = device.getAllStates();
                if (states.size() > 1 && current != null) {
                    State flip = configuration.getNextDeviceState(current);
                    String flipName = flip != null ? flip.getName() : current.getName();
                    String title = String.format("Switch to %1$s", flipName);
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, flip == null ? current : flip, false, true));
                    group.addSeparator();
                }
                for (State config : states) {
                    String stateName;
                    String title = stateName = config.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    group.add((AnAction)new SetDeviceStateAction(this.myRenderContext, title, config, config == current, false));
                }
                group.addSeparator();
            }
            group.addSeparator();
            DefaultActionGroup uiModeGroup = new DefaultActionGroup("_UI Mode", true);
            UiMode currentUiMode = configuration.getUiMode();
            for (UiMode uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, uiMode, checked));
            }
            group.add((AnAction)uiModeGroup);
            group.addSeparator();
            DefaultActionGroup nightModeGroup = new DefaultActionGroup("_Night Mode", true);
            NightMode currentNightMode = configuration.getNightMode();
            for (NightMode nightMode : NightMode.values()) {
                String title = nightMode.getShortDisplayValue();
                boolean checked = nightMode == currentNightMode;
                nightModeGroup.add((AnAction)new SetNightModeAction(this.myRenderContext, title, nightMode, checked));
            }
            group.add((AnAction)nightModeGroup);
        }
        return group;
    }

    public static Icon getOrientationIcon(ScreenOrientation orientation, boolean flip) {
        switch (orientation) {
            case LANDSCAPE: {
                return flip ? AndroidIcons.FlipLandscape : AndroidIcons.Landscape;
            }
            case SQUARE: {
                return AndroidIcons.Square;
            }
        }
        return flip ? AndroidIcons.FlipPortrait : AndroidIcons.Portrait;
    }

    public static ScreenOrientation getOrientation(State state) {
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        return orientation;
    }

    private static class SetNightModeAction
    extends ConfigurationAction {
        private final NightMode myNightMode;

        private SetNightModeAction(RenderContext renderContext, String title, NightMode nightMode, boolean checked) {
            super(renderContext, title);
            this.myNightMode = nightMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(Configuration configuration, boolean commit) {
            configuration.setNightMode(this.myNightMode);
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        private final UiMode myUiMode;

        private SetUiModeAction(RenderContext renderContext, String title, UiMode uiMode, boolean checked) {
            super(renderContext, title);
            this.myUiMode = uiMode;
            if (checked) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(Configuration configuration, boolean commit) {
            configuration.setUiMode(this.myUiMode);
        }
    }

    private static class SetDeviceStateAction
    extends ConfigurationAction {
        private final State myState;

        private SetDeviceStateAction(RenderContext renderContext, String title, State state, boolean checked, boolean flip) {
            super(renderContext, title);
            this.myState = state;
            ScreenOrientation orientation = OrientationMenuAction.getOrientation(state);
            this.getTemplatePresentation().setIcon(OrientationMenuAction.getOrientationIcon(orientation, flip));
        }

        public void perform() {
            this.tryUpdateConfiguration();
            this.updatePresentation();
            this.myRenderContext.requestRender();
        }

        @Override
        protected void updateConfiguration(Configuration configuration, boolean commit) {
            configuration.setDeviceState(this.myState);
        }
    }
}

