/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.ResourceCacheValueProvider;
import com.android.tools.idea.rendering.DataBindingInfo;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;

public class DataBindingClassFinder
extends PsiElementFinder {
    private final CachedValue<Map<String, PsiPackage>> myPackageCache;
    private final DataBindingProjectComponent myComponent;

    public DataBindingClassFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myPackageCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new ProjectResourceCachedValueProvider<Map<String, PsiPackage>, Set<String>>(this.myComponent, new ModificationTracker[0]){

            @Override
            protected Map<String, PsiPackage> merge(List<Set<String>> results) {
                HashMap merged = Maps.newHashMap();
                for (Set<String> result : results) {
                    for (String qualifiedPackage : result) {
                        if (merged.containsKey(qualifiedPackage)) continue;
                        merged.put(qualifiedPackage, DataBindingClassFinder.this.myComponent.getOrCreateDataBindingPsiPackage(qualifiedPackage));
                    }
                }
                return merged;
            }

            @Override
            ResourceCacheValueProvider<Set<String>> createCacheProvider(AndroidFacet facet) {
                return new ResourceCacheValueProvider<Set<String>>(facet, new ModificationTracker[0]){

                    @Override
                    Set<String> doCompute() {
                        LocalResourceRepository moduleResources = this.getFacet().getModuleResources(false);
                        if (moduleResources == null) {
                            return Collections.emptySet();
                        }
                        Map<String, DataBindingInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                        if (dataBindingResourceFiles == null) {
                            return Collections.emptySet();
                        }
                        HashSet result = Sets.newHashSet();
                        for (DataBindingInfo info : dataBindingResourceFiles.values()) {
                            result.add(info.getPackageName());
                        }
                        return result;
                    }

                    @Override
                    Set<String> defaultValue() {
                        return Collections.emptySet();
                    }
                };
            }
        }, false);
    }

    public PsiClass findClass(String qualifiedName, GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return null;
        }
        for (AndroidFacet facet : this.myComponent.getDataBindingEnabledFacets()) {
            DataBindingInfo dataBindingInfo;
            Map<String, DataBindingInfo> dataBindingResourceFiles;
            LocalResourceRepository moduleResources = facet.getModuleResources(false);
            if (moduleResources == null || (dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles()) == null || (dataBindingInfo = dataBindingResourceFiles.get(qualifiedName)) == null) continue;
            return DataBindingUtil.getOrCreatePsiClass(dataBindingInfo);
        }
        return null;
    }

    public PsiClass[] findClasses(String qualifiedName, GlobalSearchScope scope) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass aClass = this.findClass(qualifiedName, scope);
        if (aClass == null) {
            return PsiClass.EMPTY_ARRAY;
        }
        return new PsiClass[]{aClass};
    }

    public PsiPackage findPackage(String qualifiedName) {
        if (!this.myComponent.hasAnyDataBindingEnabledFacet()) {
            return null;
        }
        return (PsiPackage)((Map)this.myPackageCache.getValue()).get(qualifiedName);
    }
}

