/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.rendering.LocalResourceRepository;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.android.facet.AndroidFacet;

public abstract class ResourceCacheValueProvider<T>
implements CachedValueProvider<T>,
ModificationTracker {
    ModificationTracker[] myAdditionalTrackers;
    private ModificationTracker myTracker = new ModificationTracker(){
        private long myLastVersion = -1L;
        private long myVersion = 0L;

        public long getModificationCount() {
            long version;
            LocalResourceRepository moduleResources = ResourceCacheValueProvider.this.myFacet.getModuleResources(false);
            long l = version = moduleResources == null ? Integer.MIN_VALUE : moduleResources.getModificationCount();
            if (version != this.myLastVersion) {
                this.myLastVersion = version;
                ++this.myVersion;
            }
            return this.myVersion;
        }
    };
    private final AndroidFacet myFacet;

    public ResourceCacheValueProvider(AndroidFacet facet, ModificationTracker ... additionalTrackers) {
        this.myFacet = facet;
        this.myAdditionalTrackers = additionalTrackers;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    public final CachedValueProvider.Result<T> compute() {
        if (this.myFacet.getModuleResources(false) == null) {
            return CachedValueProvider.Result.create(this.defaultValue(), (Object[])new Object[]{this.myTracker});
        }
        return CachedValueProvider.Result.create(this.doCompute(), (Object[])new Object[]{this.myTracker});
    }

    abstract T doCompute();

    abstract T defaultValue();
}

