/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;

public class DeviceContext {
    private final EventDispatcher<DeviceSelectionListener> myEventDispatcher = EventDispatcher.create(DeviceSelectionListener.class);
    private IDevice mySelectedDevice;
    private Client mySelectedClient;

    public void addListener(DeviceSelectionListener l, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)l, parentDisposable);
    }

    public void fireDeviceSelected(IDevice d) {
        this.mySelectedDevice = d;
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).deviceSelected(d);
    }

    public void fireClientSelected(Client c) {
        this.mySelectedClient = c;
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).clientSelected(c);
    }

    public void fireDeviceChanged(IDevice device, int changeMask) {
        ((DeviceSelectionListener)this.myEventDispatcher.getMulticaster()).deviceChanged(device, changeMask);
    }

    public IDevice getSelectedDevice() {
        return this.mySelectedDevice;
    }

    public Client getSelectedClient() {
        return this.mySelectedClient;
    }

    public static interface DeviceSelectionListener
    extends EventListener {
        public void deviceSelected(IDevice var1);

        public void deviceChanged(IDevice var1, int var2);

        public void clientSelected(Client var1);
    }
}

