/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.editors.vmtrace.VmTraceCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;

public class OpenVmTraceHandler
implements ClientData.IMethodProfilingHandler {
    private static final Logger LOG = Logger.getInstance(OpenVmTraceHandler.class);
    private final Project myProject;

    public OpenVmTraceHandler(Project project) {
        this.myProject = project;
    }

    public void onSuccess(String remoteFilePath, Client client) {
        this.showError("Method profiling: Older devices (API level < 10) are not supported yet. Please manually retrieve the file " + remoteFilePath + " from the device and open the file to view the results.");
    }

    public void onSuccess(final byte[] data, Client client) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CaptureService service = CaptureService.getInstance(OpenVmTraceHandler.this.myProject);
                    Capture capture = service.createCapture(VmTraceCaptureType.class, data);
                    service.notifyCaptureReady(capture);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void onStartFailure(Client client, String message) {
        this.showError(message);
    }

    public void onEndFailure(Client client, String message) {
        this.showError(message);
    }

    private void showError(final String message) {
        LOG.error("Method Profiling: " + message);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)OpenVmTraceHandler.this.myProject, (String)message, (String)"Method Trace");
            }
        });
    }
}

