/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DumpSysAction;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;

public class DumpSysActions {
    public static DefaultActionGroup create(Project p, final DeviceContext context) {
        DefaultActionGroup group = new DefaultActionGroup("System Information", true){

            public void update(AnActionEvent e) {
                e.getPresentation().setText("System Information");
                e.getPresentation().setIcon(AndroidIcons.Ddms.SysInfo);
                e.getPresentation().setEnabled(context.getSelectedDevice() != null);
            }

            public boolean isDumbAware() {
                return true;
            }
        };
        group.add((AnAction)new MyDumpSysAction(p, context, "activity", "Activity Manager State"));
        group.add((AnAction)new MyDumpSysAction(p, context, "package", "Package Information"));
        group.add((AnAction)new MyDumpSysAction(p, context, "meminfo", "Memory Usage"));
        group.add((AnAction)new MyDumpProcStatsAction(p, context, "procstats", "Memory use over time"));
        group.add((AnAction)new MyDumpSysAction(p, context, "gfxinfo", "Graphics State"));
        return group;
    }

    private static class MyDumpProcStatsAction
    extends MyDumpSysAction {
        public MyDumpProcStatsAction(Project p, DeviceContext context, String service, String description) {
            super(p, context, service, description);
        }

        @Override
        protected boolean isEnabled() {
            return super.isEnabled() && this.myDeviceContext.getSelectedDevice() != null && this.myDeviceContext.getSelectedDevice().supportsFeature(IDevice.Feature.PROCSTATS);
        }
    }

    private static class MyDumpSysAction
    extends AbstractDeviceAction {
        private final String myService;
        private final Project myProject;

        public MyDumpSysAction(Project p, DeviceContext context, String service, String description) {
            super(context, description, null, null);
            this.myProject = p;
            this.myService = service;
        }

        @Override
        protected void performAction(IDevice device) {
            new DumpSysAction(this.myProject, this.myDeviceContext.getSelectedDevice(), this.myService, this.myDeviceContext.getSelectedClient()).performAction();
        }
    }
}

