/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.chartlib.EventData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientToggleAction;
import com.android.tools.idea.editors.allocations.AllocationCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;

public class ToggleAllocationTrackingAction
extends AbstractClientToggleAction {
    private final Project myProject;
    private final EventData myEvents;
    private EventData.Event myEvent;

    public ToggleAllocationTrackingAction(Project project, DeviceContext context, EventData events) {
        super(context, AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]), null, AndroidIcons.Ddms.AllocationTracker);
        this.myProject = project;
        this.myEvents = events;
    }

    @Override
    protected boolean isSelected(Client c) {
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON;
    }

    @Override
    protected void setSelected(Client c) {
        long now = System.currentTimeMillis();
        if (c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON) {
            c.requestAllocationDetails();
            c.enableAllocationTracker(false);
            if (this.myEvent == null) {
                this.myEvent = this.myEvents.start(now, 2);
            }
            this.myEvent.stop(now);
            this.myEvent = null;
        } else {
            this.installListener(c, this.myProject);
            c.enableAllocationTracker(true);
            if (this.myEvent != null) {
                this.myEvent.stop(now);
            }
            this.myEvent = this.myEvents.start(now, 2);
        }
        c.requestAllocationStatus();
    }

    @Override
    protected String getActiveText(Client c) {
        return c.getClientData().getAllocationStatus() == ClientData.AllocationTrackingStatus.ON ? AndroidBundle.message("android.ddms.actions.allocationtracker.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.allocationtracker.start", new Object[0]);
    }

    private void installListener(final Client listeningClient, Project project) {
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)new AndroidDebugBridge.IClientChangeListener(){

            public void clientChanged(Client client, int changeMask) {
                if (client == listeningClient && (changeMask & 0x200) != 0) {
                    final byte[] data = client.getClientData().getAllocationsData();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (ToggleAllocationTrackingAction.this.myProject.isDisposed()) {
                                    return;
                                }
                                CaptureService service = CaptureService.getInstance(ToggleAllocationTrackingAction.this.myProject);
                                Capture capture = service.createCapture(AllocationCaptureType.class, data);
                                service.notifyCaptureReady(capture);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                    AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
                }
            }
        });
    }
}

