/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractClientToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import icons.AndroidIcons;
import java.io.IOException;
import org.jetbrains.android.util.AndroidBundle;

public class ToggleMethodProfilingAction
extends AbstractClientToggleAction {
    private final Project myProject;

    public ToggleMethodProfilingAction(Project p, DeviceContext context) {
        super(context, AndroidBundle.message("android.ddms.actions.methodprofile.start", new Object[0]), null, AndroidIcons.Ddms.StartMethodProfiling);
        this.myProject = p;
    }

    @Override
    protected boolean isSelected(Client c) {
        ClientData cd = c.getClientData();
        return cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON || cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.SAMPLER_ON;
    }

    @Override
    protected void setSelected(Client c) {
        ClientData cd = c.getClientData();
        try {
            if (cd.getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON) {
                c.stopMethodTracer();
            } else {
                c.startMethodTracer();
            }
        }
        catch (IOException e1) {
            Messages.showErrorDialog((Project)this.myProject, (String)("Unexpected error while toggling method profiling: " + e1), (String)"Method Profiling");
        }
    }

    @Override
    protected String getActiveText(Client c) {
        return c.getClientData().getMethodProfilingStatus() == ClientData.MethodProfilingStatus.TRACER_ON ? AndroidBundle.message("android.ddms.actions.methodprofile.stop", new Object[0]) : AndroidBundle.message("android.ddms.actions.methodprofile.start", new Object[0]);
    }
}

