/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.ddmlib.Log;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;

public class AdbLogOutput {

    public static class ToStringLogger
    implements Log.ILogOutput {
        private final StringBuilder sb = new StringBuilder(100);

        public void printLog(Log.LogLevel logLevel, String tag, String message) {
            this.append(message);
        }

        public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
            this.append(message);
        }

        private void append(String message) {
            if (!StringUtil.isEmpty((String)message)) {
                this.sb.append(message);
                this.sb.append('\n');
            }
        }

        public String getOutput() {
            return this.sb.toString();
        }
    }

    public static class SystemLogRedirecter
    implements Log.ILogOutput {
        private static final NotificationGroup EVENT_LOG = NotificationGroup.logOnlyGroup((String)"ADB Logs");
        private static final Logger LOG = Logger.getInstance((String)"#com.android.ddmlib");

        public void printLog(Log.LogLevel logLevel, String tag, String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        public void printAndPromptLog(Log.LogLevel logLevel, String tag, String message) {
            SystemLogRedirecter.reportAdbLog(logLevel, tag, message);
        }

        private static void reportAdbLog(Log.LogLevel logLevel, String tag, String message) {
            if (StringUtil.isEmpty((String)message)) {
                return;
            }
            if (logLevel == null) {
                logLevel = Log.LogLevel.DEBUG;
            }
            switch (logLevel) {
                case VERBOSE: 
                case DEBUG: {
                    LOG.debug(message);
                    break;
                }
                case INFO: {
                    LOG.info(message);
                    break;
                }
                case WARN: {
                    LOG.warn(message);
                    break;
                }
                case ERROR: 
                case ASSERT: {
                    LOG.warn(message);
                    EVENT_LOG.createNotification(message, MessageType.ERROR).notify(null);
                }
            }
        }
    }
}

