/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.adb;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.ddms.adb.AdbService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.android.sdk.AndroidSdkUtils;

public class GetAdbAction
extends AnAction {
    public GetAdbAction() {
        super("Get ADB");
    }

    public void update(AnActionEvent e) {
        Project project = GetAdbAction.getEventProject((AnActionEvent)e);
        File adb = project == null ? null : AndroidSdkUtils.getAdb(project);
        this.getTemplatePresentation().setEnabled(adb != null && adb.exists());
    }

    public void actionPerformed(AnActionEvent e) {
        File adb;
        Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB requested.", NotificationType.INFORMATION));
        Project project = GetAdbAction.getEventProject((AnActionEvent)e);
        File file = adb = project == null ? null : AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        ListenableFuture<AndroidDebugBridge> bridge = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(bridge, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge result) {
                Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB obtained", NotificationType.INFORMATION));
            }

            public void onFailure(Throwable t) {
                Notifications.Bus.notify((Notification)new Notification("Android", "ADB", "ADB error: " + t.toString(), NotificationType.INFORMATION));
            }
        });
    }
}

