/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.screenshot;

import com.android.resources.ScreenOrientation;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashSet;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceArtDescriptor {
    public static final DeviceArtDescriptor NONE = new DeviceArtDescriptor(null, null);
    private final String myId;
    private final String myName;
    private final File myFolder;
    private OrientationData myPortrait;
    private OrientationData myLandscape;
    @NonNls
    private static final String FN_BASE = "device-art-resources";
    @NonNls
    private static final String FN_DESCRIPTOR = "device-art.xml";

    public static File getBundledDescriptorsFolder() {
        String[] paths;
        File base;
        File androidJar;
        String androidJarPath = PathManager.getJarPathForClass(DeviceArtDescriptor.class);
        if (androidJarPath != null && (androidJar = new File(androidJarPath)).isFile() && (base = new File(androidJar.getParentFile(), FN_BASE)).exists() && base.isDirectory()) {
            return base;
        }
        String basePath = PathManager.getHomePath();
        for (String p : paths = new String[]{"plugins" + File.separatorChar + "android" + File.separatorChar, ".." + File.separator + "adt" + File.separator + "idea" + File.separator + "android" + File.separatorChar, "android" + File.separatorChar + "android" + File.separatorChar, "community" + File.separatorChar + "android" + File.separatorChar + "android" + File.separatorChar}) {
            File files;
            File base2 = new File(basePath, p);
            if (!base2.isDirectory() || !(files = new File(base2, FN_BASE)).isDirectory()) continue;
            return files;
        }
        return null;
    }

    private static File getDescriptorFile(File folder) {
        File file = new File(folder, FN_DESCRIPTOR);
        return file.isFile() ? file : null;
    }

    private static List<File> getDescriptorFiles(File[] additionalRoots) {
        HashSet roots = new HashSet();
        File base = DeviceArtDescriptor.getBundledDescriptorsFolder();
        if (base != null) {
            roots.add(base);
        }
        if (additionalRoots != null) {
            Collections.addAll(roots, additionalRoots);
        }
        ArrayList<File> files = new ArrayList<File>(roots.size());
        for (File root : roots) {
            File file = DeviceArtDescriptor.getDescriptorFile(root);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public static List<DeviceArtDescriptor> getDescriptors(File[] folders) {
        List<File> files = DeviceArtDescriptor.getDescriptorFiles(folders);
        ArrayList result = Lists.newArrayList();
        for (File file : files) {
            try {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)false);
                if (document != null) {
                    File baseFolder = file.getParentFile();
                    DeviceArtDescriptor.addDescriptors(result, document, baseFolder);
                    continue;
                }
                Logger.getInstance(DeviceArtDescriptor.class).error("Couldn't parse " + file);
            }
            catch (IOException e) {
                Logger.getInstance(DeviceArtDescriptor.class).error((Throwable)e);
            }
        }
        return result;
    }

    private DeviceArtDescriptor(File baseFolder, Element element) {
        if (element == null) {
            this.myName = "";
            this.myId = "";
            this.myFolder = null;
        } else {
            this.myId = element.getAttribute("id");
            this.myName = element.getAttribute("name");
            this.myFolder = new File(baseFolder, this.myId);
            List children = LintUtils.getChildren((Node)element);
            for (Element child : children) {
                OrientationData orientation = new OrientationData(this, child);
                if (orientation.isPortrait()) {
                    this.myPortrait = orientation;
                    continue;
                }
                this.myLandscape = orientation;
            }
        }
    }

    static void addDescriptors(List<DeviceArtDescriptor> result, Document document, File baseFolder) {
        NodeList deviceList = document.getElementsByTagName("device");
        for (int i = 0; i < deviceList.getLength(); ++i) {
            Element element = (Element)deviceList.item(i);
            DeviceArtDescriptor descriptor = new DeviceArtDescriptor(baseFolder, element);
            result.add(descriptor);
        }
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public OrientationData getArtDescriptor(ScreenOrientation orientation) {
        return orientation == ScreenOrientation.PORTRAIT ? this.myPortrait : this.myLandscape;
    }

    public File getBaseFolder() {
        return this.myFolder;
    }

    public Dimension getScreenSize(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getScreenSize();
    }

    public Point getScreenPos(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getScreenPos();
    }

    public Dimension getFrameSize(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getFrameSize();
    }

    public Rectangle getCrop(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getCrop();
    }

    public File getFrame(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getBackgroundFile();
    }

    public File getDropShadow(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getShadowFile();
    }

    public File getReflectionOverlay(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getReflectionFile();
    }

    public File getMask(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getMaskFile();
    }

    public double getAspectRatio(ScreenOrientation orientation) {
        return this.getArtDescriptor(orientation).getAspectRatio();
    }

    public boolean isStretchable() {
        return this.myId.equals("phone") || this.myId.equals("tablet");
    }

    public boolean canFrameImage(BufferedImage image, ScreenOrientation orientation) {
        double descriptorAspectRatio;
        if (this.isStretchable()) {
            return true;
        }
        if (orientation == ScreenOrientation.PORTRAIT && this.myPortrait == null) {
            return false;
        }
        if (orientation == ScreenOrientation.LANDSCAPE && this.myLandscape == null) {
            return false;
        }
        Dimension screenSize = this.getArtDescriptor(orientation).getScreenSize();
        if ((double)image.getWidth() < screenSize.getWidth() || (double)image.getHeight() < screenSize.getHeight()) {
            return false;
        }
        double imgAspectRatio = (double)image.getWidth() / (double)image.getHeight();
        return Math.abs(imgAspectRatio - (descriptorAspectRatio = this.getAspectRatio(orientation))) < 1.0E-5;
    }

    private static class OrientationData {
        private final DeviceArtDescriptor myDevice;
        private final String myShadowName;
        private final String myBackgroundName;
        private final String myReflectionName;
        private final String myMaskName;
        private final Dimension myScreenSize;
        private final Point myScreenPos;
        private final Dimension myFrameSize;
        private final Rectangle myCrop;
        private final ScreenOrientation myOrientation;

        OrientationData(DeviceArtDescriptor device, Element element) {
            this.myDevice = device;
            String orientation = element.getAttribute("name");
            if ("port".equals(orientation)) {
                this.myOrientation = ScreenOrientation.PORTRAIT;
            } else {
                assert ("land".equals(orientation)) : orientation;
                this.myOrientation = ScreenOrientation.LANDSCAPE;
            }
            this.myFrameSize = OrientationData.getDimension(element.getAttribute("size"));
            this.myScreenSize = OrientationData.getDimension(element.getAttribute("screenSize"));
            this.myScreenPos = OrientationData.getPoint(element.getAttribute("screenPos"));
            this.myCrop = OrientationData.getRectangle(element.getAttribute("crop"));
            this.myBackgroundName = OrientationData.getFileName(element, "back");
            this.myShadowName = OrientationData.getFileName(element, "shadow");
            this.myReflectionName = OrientationData.getFileName(element, "lights");
            this.myMaskName = OrientationData.getFileName(element, "mask");
        }

        private static String getFileName(Element element, String name) {
            return name != null && !name.isEmpty() ? element.getAttribute(name) : null;
        }

        private static Dimension getDimension(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            int comma = value.indexOf(44);
            if (comma == -1) {
                return null;
            }
            return new Dimension(OrientationData.getInteger(value.substring(0, comma)), OrientationData.getInteger(value.substring(comma + 1)));
        }

        private static Point getPoint(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            int comma = value.indexOf(44);
            if (comma == -1) {
                return null;
            }
            return new Point(OrientationData.getInteger(value.substring(0, comma)), OrientationData.getInteger(value.substring(comma + 1)));
        }

        private static Rectangle getRectangle(String value) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            int comma1 = value.indexOf(44);
            if (comma1 == -1) {
                return null;
            }
            int comma2 = value.indexOf(44, comma1 + 1);
            if (comma2 == -1) {
                return null;
            }
            int comma3 = value.indexOf(44, comma2 + 1);
            if (comma3 == -1) {
                return null;
            }
            String x = value.substring(0, comma1);
            String y = value.substring(comma1 + 1, comma2);
            String w = value.substring(comma2 + 1, comma3);
            String h = value.substring(comma3 + 1);
            return new Rectangle(OrientationData.getInteger(x), OrientationData.getInteger(y), OrientationData.getInteger(w), OrientationData.getInteger(h));
        }

        private static int getInteger(String value) {
            return Integer.parseInt(value);
        }

        public boolean isPortrait() {
            return this.myOrientation == ScreenOrientation.PORTRAIT;
        }

        public Dimension getScreenSize() {
            return this.myScreenSize;
        }

        public Point getScreenPos() {
            return this.myScreenPos;
        }

        public Dimension getFrameSize() {
            return this.myFrameSize;
        }

        public Rectangle getCrop() {
            return this.myCrop;
        }

        public ScreenOrientation getOrientation() {
            return this.myOrientation;
        }

        public File getBackgroundFile() {
            return !StringUtil.isEmpty((String)this.myBackgroundName) ? new File(this.myDevice.getBaseFolder(), this.myBackgroundName) : null;
        }

        public File getShadowFile() {
            return !StringUtil.isEmpty((String)this.myShadowName) ? new File(this.myDevice.getBaseFolder(), this.myShadowName) : null;
        }

        public File getReflectionFile() {
            return !StringUtil.isEmpty((String)this.myReflectionName) ? new File(this.myDevice.getBaseFolder(), this.myReflectionName) : null;
        }

        public File getMaskFile() {
            return !StringUtil.isEmpty((String)this.myMaskName) ? new File(this.myDevice.getBaseFolder(), this.myMaskName) : null;
        }

        public double getAspectRatio() {
            return (double)this.myScreenSize.width / (double)this.myScreenSize.height;
        }
    }
}

