/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;

public class ArrayMapRendererBase
extends NodeRendererImpl {
    private static final int MAX_CHILDREN = 10;
    @NonNls
    private static final String MORE_ELEMENTS = "...";
    private final String myFqn;
    private final LabelRenderer myLabelRenderer = new LabelRenderer();
    private final MyArrayMapSizeEvaluator mySizeEvaluator = new MyArrayMapSizeEvaluator();

    public ArrayMapRendererBase(String mapFqn) {
        this.myProperties.setEnabled(true);
        this.myProperties.setName(mapFqn);
        this.myFqn = mapFqn;
    }

    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        int size;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayList<DebuggerTreeNodeImpl> children = new ArrayList<DebuggerTreeNodeImpl>();
        NodeManagerImpl nodeManager = (NodeManagerImpl)builder.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
        try {
            size = this.getArrayMapSize(value, evaluationContext);
        }
        catch (Exception e) {
            size = 0;
        }
        int n = Math.min(size, 10);
        for (int i = 0; i < n; ++i) {
            String expression = String.format("this.valueAt(%1$d)", i);
            UserExpressionData descriptorData = new UserExpressionData((ValueDescriptorImpl)builder.getParentDescriptor(), this.myFqn, String.format("value[%1$d]", i), (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression, "", (FileType)StdFileTypes.JAVA));
            UserExpressionDescriptor userExpressionDescriptor = descriptorFactory.getUserExpressionDescriptor((NodeDescriptor)builder.getParentDescriptor(), (DescriptorData)descriptorData);
            DebuggerTreeNodeImpl arrayMapItemNode = nodeManager.createNode((NodeDescriptor)userExpressionDescriptor, evaluationContext);
            children.add(arrayMapItemNode);
        }
        if (size > 10) {
            children.add(nodeManager.createMessageNode(new MessageDescriptor(MORE_ELEMENTS, 3)));
        }
        builder.setChildren(children);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }

    public boolean isExpandable(Value value, EvaluationContext context, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.getArrayMapIsEmpty(value, context);
    }

    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener) throws EvaluateException {
        if (!(descriptor.getValue() instanceof ObjectReference)) {
            return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
        }
        ObjectReference ref = (ObjectReference)descriptor.getValue();
        this.myLabelRenderer.setLabelExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)StdFileTypes.JAVA));
        return ValueDescriptorImpl.getIdLabel((ObjectReference)ref) + ", size = " + this.myLabelRenderer.calcLabel(descriptor, evaluationContext, listener);
    }

    public String getUniqueId() {
        return this.myFqn;
    }

    public boolean isApplicable(Type type) {
        return type != null && this.myFqn.equals(type.name());
    }

    private boolean getArrayMapIsEmpty(Value arrayMapValue, EvaluationContext context) {
        try {
            return this.getArrayMapSize(arrayMapValue, context) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getArrayMapSize(Value arrayMapValue, EvaluationContext context) throws InvalidTypeException, EvaluateException {
        EvaluationContext evaluationContext = context.createEvaluationContext(arrayMapValue);
        Value v = this.mySizeEvaluator.evaluate(evaluationContext.getProject(), evaluationContext);
        if (v instanceof IntegerValue) {
            return ((IntegerValue)v).intValue();
        }
        throw new InvalidTypeException();
    }

    private class MyArrayMapSizeEvaluator
    extends CachedEvaluator {
        public MyArrayMapSizeEvaluator() {
            this.setReferenceExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)StdFileTypes.JAVA));
        }

        protected String getClassName() {
            return ArrayMapRendererBase.this.myFqn;
        }

        public Value evaluate(Project p, EvaluationContext context) throws EvaluateException {
            return this.getEvaluator(p).evaluate(context);
        }
    }
}

