/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.BitmapEvaluator;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.settings.CustomPopupFullValueEvaluator;
import com.intellij.openapi.ui.Messages;
import com.sun.jdi.Value;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;

abstract class BitmapPopupEvaluator
extends CustomPopupFullValueEvaluator<BufferedImage> {
    private String myError;

    public BitmapPopupEvaluator(EvaluationContextImpl evaluationContext) {
        super("\u2026 View Bitmap", evaluationContext);
    }

    public BufferedImage getImage(EvaluationContextImpl evaluationContext, Value value) {
        try {
            return BitmapEvaluator.getBitmap(evaluationContext, value);
        }
        catch (EvaluateException e) {
            this.myError = "Error while evaluating expression: " + e.getMessage();
            return null;
        }
        catch (Exception e) {
            this.myError = "Unexpected error: " + e.getMessage();
            return null;
        }
    }

    protected JComponent createComponent(BufferedImage image) {
        if (image == null) {
            String message = this.myError == null ? "Unexpected error while obtaining image" : this.myError;
            return new JLabel(message, Messages.getErrorIcon(), 0);
        }
        return ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
    }
}

