/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.designer;

import com.android.tools.idea.designer.AndroidVariationPaletteItem;
import com.intellij.android.designer.designSurface.graphics.DirectionResizePoint;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.designer.palette.PaletteItem;
import org.jetbrains.annotations.NonNls;

public class ResizePolicy {
    private static final int NONE = 0;
    private static final int LEFT_EDGE = 1;
    private static final int RIGHT_EDGE = 2;
    private static final int TOP_EDGE = 4;
    private static final int BOTTOM_EDGE = 8;
    private static final int PRESERVE_RATIO = 16;
    private static final int HORIZONTAL = 3;
    private static final int VERTICAL = 12;
    private static final int ANY = 15;
    private static final ResizePolicy ourAny = new ResizePolicy(15);
    private static final ResizePolicy ourNone = new ResizePolicy(0);
    private static final ResizePolicy ourHorizontal = new ResizePolicy(3);
    private static final ResizePolicy ourVertical = new ResizePolicy(12);
    private static final ResizePolicy ourScaled = new ResizePolicy(31);
    private final int myFlags;

    private ResizePolicy(int flags) {
        this.myFlags = flags;
    }

    public boolean isResizable() {
        return (this.myFlags & 0xF) != 0;
    }

    public boolean topAllowed() {
        return (this.myFlags & 4) != 0;
    }

    public boolean rightAllowed() {
        return (this.myFlags & 2) != 0;
    }

    public boolean bottomAllowed() {
        return (this.myFlags & 8) != 0;
    }

    public boolean leftAllowed() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isAspectPreserving() {
        return (this.myFlags & 0x10) != 0;
    }

    public static ResizePolicy full() {
        return ourAny;
    }

    public static ResizePolicy none() {
        return ourNone;
    }

    public static ResizePolicy horizontal() {
        return ourHorizontal;
    }

    public static ResizePolicy vertical() {
        return ourVertical;
    }

    public static ResizePolicy scaled() {
        return ourScaled;
    }

    public static ResizePolicy create(boolean top, boolean right, boolean bottom, boolean left, boolean preserve) {
        int mask = 0;
        if (top) {
            mask |= 4;
        }
        if (right) {
            mask |= 2;
        }
        if (bottom) {
            mask |= 8;
        }
        if (left) {
            mask |= 1;
        }
        if (preserve) {
            mask |= 0x10;
        }
        return new ResizePolicy(mask);
    }

    public static ResizePolicy get(@NonNls String resize) {
        if (resize != null && resize.length() > 0) {
            if ("full".equals(resize)) {
                return ResizePolicy.full();
            }
            if ("none".equals(resize)) {
                return ResizePolicy.none();
            }
            if ("horizontal".equals(resize)) {
                return ResizePolicy.horizontal();
            }
            if ("vertical".equals(resize)) {
                return ResizePolicy.vertical();
            }
            if ("scaled".equals(resize)) {
                return ResizePolicy.scaled();
            }
            assert (false) : resize;
        }
        return null;
    }

    public static ResizePolicy getResizePolicy(RadViewComponent component) {
        AndroidVariationPaletteItem item;
        ResizePolicy policy;
        PaletteItem paletteItem = component.getInitialPaletteItem();
        if (paletteItem instanceof AndroidVariationPaletteItem && (policy = (item = (AndroidVariationPaletteItem)paletteItem).getResizePolicy()) != null) {
            return policy;
        }
        return component.getMetaModel().getResizePolicy();
    }

    public boolean applies(DirectionResizePoint point) {
        return this.applies(point.getDirection());
    }

    protected boolean applies(int direction) {
        switch (direction) {
            case 8: {
                return this.rightAllowed();
            }
            case 4: {
                return this.leftAllowed();
            }
            case 1: {
                return this.topAllowed();
            }
            case 2: {
                return this.bottomAllowed();
            }
            case 9: {
                return this.rightAllowed() && this.topAllowed();
            }
            case 10: {
                return this.rightAllowed() && this.bottomAllowed();
            }
            case 6: {
                return this.rightAllowed() && this.bottomAllowed();
            }
            case 5: {
                return this.rightAllowed() && this.topAllowed();
            }
        }
        return false;
    }
}

