/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations.nodes;

import com.android.tools.chartlib.ValuedTreeNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class AbstractTreeNode
implements ValuedTreeNode {
    protected AbstractTreeNode myParent;
    private Comparator<AbstractTreeNode> myOrder = null;
    int myCount;
    int myValue;
    private Vector<AbstractTreeNode> myChildren = new Vector();

    public TreeNode getChildAt(int i) {
        this.ensureOrder();
        return (TreeNode)((Object)this.myChildren.get(i));
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public TreeNode getParent() {
        return this.myParent;
    }

    public int getIndex(TreeNode treeNode) {
        assert (treeNode instanceof AbstractTreeNode);
        return this.myChildren.indexOf(treeNode);
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    public Enumeration children() {
        this.ensureOrder();
        return this.myChildren.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int getCount() {
        return this.myCount;
    }

    public int getValue() {
        return this.myValue;
    }

    private void add(int count, int value) {
        this.myCount += count;
        this.myValue += value;
        if (this.myParent != null) {
            this.myParent.add(count, value);
        }
    }

    public void addChild(AbstractTreeNode node) {
        this.myChildren.add(node);
        node.myParent = this;
        this.add(node.getCount(), node.getValue());
    }

    private void ensureOrder() {
        if (this.myParent != null && this.myParent.myOrder != this.myOrder || this.myParent == null && this.myOrder != null) {
            this.myOrder = this.myParent != null ? this.myParent.myOrder : this.myOrder;
            Collections.sort(this.myChildren, this.myOrder);
        }
    }

    public void sort(Comparator<AbstractTreeNode> order) {
        assert (this.myParent == null);
        this.myOrder = order;
        this.ensureOrder();
    }
}

