/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.MainController;
import com.android.tools.idea.editors.gfxtrace.service.Factory;
import com.android.tools.idea.editors.gfxtrace.service.Schema;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientCache;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClientRPC;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomMetadata;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.ConstantSet;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.SchemaClass;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;

public class GfxTraceEditor
extends UserDataHolderBase
implements FileEditor {
    public static final String SELECT_CAPTURE = "Select a capture";
    public static final String SELECT_ATOM = "Select an atom";
    private static final String OVERRIDE_PATH_GAPIS = "override.path.gapis";
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private static final String SERVER_HOST = "localhost";
    private static final String SERVER_EXECUTABLE_NAME = "gapis";
    private static final String SERVER_RELATIVE_PATH = "bin";
    private static final int SERVER_PORT = 6700;
    private static final int SERVER_LAUNCH_TIMEOUT_MS = 2000;
    private static final int SERVER_LAUNCH_SLEEP_INCREMENT_MS = 10;
    private final Project myProject;
    private LoadingDecorator myLoadingDecorator;
    private JBPanel myView = new JBPanel((LayoutManager)new BorderLayout());
    private final ListeningExecutorService myExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private Process myServerProcess;
    private Socket myServerSocket;
    private ServiceClient myClient;
    private List<PathListener> myPathListeners = new ArrayList<PathListener>();

    public GfxTraceEditor(Project project, final VirtualFile file) {
        this.myProject = project;
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myView, (Disposable)this, 0);
        this.myLoadingDecorator.setLoadingText("Initializing GFX Trace System");
        this.myLoadingDecorator.startLoading(false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (!GfxTraceEditor.this.connectToServer()) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to connect to server");
                    return;
                }
                try {
                    ServiceClientRPC rpcClient = new ServiceClientRPC(GfxTraceEditor.this.myExecutor, GfxTraceEditor.this.myServerSocket.getInputStream(), GfxTraceEditor.this.myServerSocket.getOutputStream(), 1024);
                    GfxTraceEditor.this.myClient = new ServiceClientCache(rpcClient);
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Unable to talk to server");
                    return;
                }
                ListenableFuture<Schema> schemaF = GfxTraceEditor.this.myClient.getSchema();
                Futures.addCallback(schemaF, (FutureCallback)new LoadingCallback<Schema>(LOG){

                    public void onSuccess(Schema schema) {
                        LOG.info("Schema with " + schema.getClasses().length + " classes, " + schema.getConstants().length + " constant sets");
                        int atoms = 0;
                        for (SchemaClass schemaClass : schema.getClasses()) {
                            if (AtomMetadata.find(schemaClass) != null) {
                                ++atoms;
                            }
                            Dynamic.register((SchemaClass)schemaClass);
                        }
                        LOG.info("Schema with " + atoms + " atoms");
                        for (SchemaClass schemaClass : schema.getConstants()) {
                            ConstantSet.register((ConstantSet)schemaClass);
                        }
                    }
                });
                try {
                    byte[] data = file.contentsToByteArray();
                    LOG.info("Upload " + data.length + " bytes of gfxtrace as " + file.getPresentableName());
                    ListenableFuture<CapturePath> captureF = GfxTraceEditor.this.myClient.importCapture(file.getPresentableName(), data);
                    Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{schemaF, captureF}), (FutureCallback)new LoadingCallback<List<BinaryObject>>(LOG){

                        public void onSuccess(List<BinaryObject> all) {
                            CapturePath path = (CapturePath)all.get(1);
                            LOG.info("Capture uploaded");
                            if (path != null) {
                                GfxTraceEditor.this.activatePath(path);
                            } else {
                                LOG.error("Invalid capture file " + file.getPresentableName());
                            }
                        }
                    });
                }
                catch (IOException e) {
                    GfxTraceEditor.this.setLoadingErrorTextOnEdt("Error reading gfxtrace file");
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GfxTraceEditor.this.myView.add((Component)MainController.createUI(GfxTraceEditor.this), (Object)"Center");
                        GfxTraceEditor.this.myLoadingDecorator.stopLoading();
                    }
                });
            }
        });
    }

    public Project getProject() {
        return this.myProject;
    }

    public JComponent getComponent() {
        return this.myView;
    }

    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public String getName() {
        return "GfxTraceView";
    }

    public void activatePath(final Path path) {
        EdtExecutor.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                LOG.warn("Activate path " + path);
                for (PathListener listener : GfxTraceEditor.this.myPathListeners) {
                    listener.notifyPath(path);
                }
            }
        });
    }

    public void addPathListener(PathListener listener) {
        this.myPathListeners.add(listener);
    }

    public FileEditorState getState(FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public ServiceClient getClient() {
        return this.myClient;
    }

    public ListeningExecutorService getExecutor() {
        return this.myExecutor;
    }

    public void dispose() {
        this.shutdown();
    }

    private boolean connectToServer() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Factory.register();
        this.myServerSocket = null;
        try {
            this.myServerSocket = new Socket(SERVER_HOST, 6700);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (this.myServerSocket != null) {
            return true;
        }
        try {
            File androidPluginDirectory = PluginPathManager.getPluginHome((String)"android");
            String pathOverride = System.getProperty(OVERRIDE_PATH_GAPIS, "");
            if (pathOverride.length() > 0) {
                androidPluginDirectory = new File(pathOverride);
            }
            File serverDirectory = new File(androidPluginDirectory, SERVER_RELATIVE_PATH);
            File serverExecutable = new File(serverDirectory, SERVER_EXECUTABLE_NAME);
            LOG.info("launch gapis: \"" + serverExecutable.getAbsolutePath() + "\"");
            ProcessBuilder pb = new ProcessBuilder(serverExecutable.getAbsolutePath());
            Map<String, String> env = pb.environment();
            String path = env.get("PATH");
            path = serverDirectory.getAbsolutePath() + File.pathSeparator + path;
            env.put("PATH", path);
            pb.directory(androidPluginDirectory);
            this.myServerProcess = pb.start();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
        for (int waitTime = 0; waitTime < 2000; waitTime += 10) {
            try {
                this.myServerSocket = new Socket(SERVER_HOST, 6700);
                return true;
            }
            catch (IOException e1) {
                this.myServerSocket = null;
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    this.shutdown();
                    return false;
                }
            }
        }
        this.shutdown();
        return false;
    }

    private void setLoadingErrorTextOnEdt(final String error) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                GfxTraceEditor.this.myLoadingDecorator.setLoadingText(error);
            }
        });
    }

    private void shutdown() {
        if (this.myServerSocket != null) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myServerProcess != null) {
            this.myServerProcess.destroy();
        }
        this.myExecutor.shutdown();
    }
}

