/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace;

import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBLoadingPanel;

public abstract class LoadingCallback<T>
implements FutureCallback<T> {
    private final Logger myLogger;
    private final LoadingDone myLoading;

    public LoadingCallback(Logger logger) {
        this.myLogger = logger;
        this.myLoading = null;
    }

    public LoadingCallback(Logger logger, JBLoadingPanel loading) {
        this.myLogger = logger;
        this.myLoading = new LoadingDonePanel(loading);
    }

    public LoadingCallback(Logger logger, LoadingDone loading) {
        this.myLogger = logger;
        this.myLoading = loading;
    }

    public void onFailure(Throwable t) {
        if (this.myLogger != null) {
            this.myLogger.error(t);
        }
        if (this.myLoading != null) {
            this.myLoading.stopLoading();
        }
    }

    private static class LoadingDonePanel
    implements LoadingDone {
        private final JBLoadingPanel myLoadingPanel;

        private LoadingDonePanel(JBLoadingPanel loadingPanel) {
            this.myLoadingPanel = loadingPanel;
        }

        @Override
        public void stopLoading() {
            if (this.myLoadingPanel != null) {
                this.myLoadingPanel.stopLoading();
            }
        }
    }

    public static interface LoadingDone {
        public void stopLoading();
    }
}

