/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.TreeController;
import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomGroup;
import com.android.tools.idea.editors.gfxtrace.service.atom.AtomList;
import com.android.tools.idea.editors.gfxtrace.service.atom.Observation;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.rpclib.binary.BinaryObject;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AtomController
extends TreeController {
    private static final Logger LOG = Logger.getInstance(GfxTraceEditor.class);
    private final PathStore<AtomsPath> myAtomsPath = new PathStore();
    private boolean mDisableActivation = false;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new AtomController((GfxTraceEditor)editor).myPanel;
    }

    private AtomController(GfxTraceEditor editor) {
        super(editor, "Select a capture");
        this.myTree.setLargeModel(true);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                if (AtomController.this.mDisableActivation || AtomController.this.myAtomsPath.getPath() == null) {
                    return;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AtomController.this.myTree.getLastSelectedPathComponent();
                if (node == null || node.getUserObject() == null) {
                    return;
                }
                Object object = node.getUserObject();
                if (object instanceof AtomGroup) {
                    AtomController.this.myEditor.activatePath(((AtomsPath)AtomController.this.myAtomsPath.getPath()).index(((AtomGroup)object).getRange().getLast()));
                } else if (object instanceof Node) {
                    AtomController.this.myEditor.activatePath(((AtomsPath)AtomController.this.myAtomsPath.getPath()).index(((Node)object).index));
                }
            }
        });
    }

    public void selectDeepestVisibleNode(long atomIndex) {
        Object object = this.myTree.getModel().getRoot();
        assert (object instanceof DefaultMutableTreeNode);
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)object;
        this.selectDeepestVisibleNode(root, new TreePath(root), atomIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectDeepestVisibleNode(DefaultMutableTreeNode node, TreePath path, long atomIndex) {
        if (node.isLeaf() || !this.myTree.isExpanded(path)) {
            try {
                this.mDisableActivation = true;
                this.myTree.setSelectionPath(path);
                this.myTree.scrollPathToVisible(path);
                return;
            }
            finally {
                this.mDisableActivation = false;
            }
        }
        Enumeration<TreeNode> it = node.children();
        while (it.hasMoreElements()) {
            TreeNode obj = it.nextElement();
            assert (obj instanceof DefaultMutableTreeNode);
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)obj;
            Object object = child.getUserObject();
            boolean matches = false;
            if (object instanceof AtomGroup && ((AtomGroup)object).getRange().contains(atomIndex) || object instanceof Node && ((Node)object).index == atomIndex) {
                matches = true;
            }
            if (!matches) continue;
            this.selectDeepestVisibleNode(child, path.pathByAddingChild(child), atomIndex);
        }
    }

    @Override
    public void notifyPath(Path path) {
        boolean updateAtoms = false;
        if (path instanceof CapturePath) {
            updateAtoms |= this.myAtomsPath.update(((CapturePath)path).atoms());
        }
        if (path instanceof AtomPath) {
            this.selectDeepestVisibleNode(((AtomPath)path).getIndex());
        }
        if (updateAtoms && this.myAtomsPath.getPath() != null) {
            this.myTree.getEmptyText().setText("");
            this.myLoadingPanel.startLoading();
            ListenableFuture<AtomList> atomF = this.myEditor.getClient().get(this.myAtomsPath.getPath());
            ListenableFuture<AtomGroup> hierarchyF = this.myEditor.getClient().get(this.myAtomsPath.getPath().getCapture().hierarchy());
            Futures.addCallback((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{atomF, hierarchyF}), (FutureCallback)new LoadingCallback<List<BinaryObject>>(LOG, this.myLoadingPanel){

                public void onSuccess(List<BinaryObject> all) {
                    AtomController.this.myLoadingPanel.stopLoading();
                    AtomList atoms = (AtomList)all.get(0);
                    AtomGroup group = (AtomGroup)all.get(1);
                    final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Stream", true);
                    group.addChildren(root, atoms);
                    EdtExecutor.INSTANCE.execute(new Runnable(){

                        @Override
                        public void run() {
                            AtomController.this.setRoot(root);
                        }
                    });
                }
            });
        }
    }

    public static class Memory {
        public final Observation observation;
        public final boolean isRead;

        public Memory(Observation observation, boolean isRead) {
            this.observation = observation;
            this.isRead = isRead;
        }
    }

    public static class Node {
        public final long index;
        public final Atom atom;

        public Node(long index, Atom atom) {
            this.index = index;
            this.atom = atom;
        }
    }
}

