/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.LoadingCallback;
import com.android.tools.idea.editors.gfxtrace.controllers.Controller;
import com.android.tools.idea.editors.gfxtrace.renderers.CellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class CellController<T extends Data>
extends Controller {
    private static final Logger LOG = Logger.getInstance(CellController.class);
    protected final JBScrollPane myScrollPane = new JBScrollPane();
    protected final JBList myList = new JBList();
    protected final JPanel myPanel = new JPanel(new BorderLayout());
    protected final CellRenderer myRenderer;
    protected List<T> myData;

    public CellController(GfxTraceEditor editor) {
        super(editor);
        this.myList.setLayoutOrientation(2);
        this.myScrollPane.setViewportView((Component)this.myList);
        this.myPanel.add((Component)this.myScrollPane, "Center");
        this.myRenderer = new CellRenderer(this);
        Dimension minCellDimension = this.myRenderer.getCellDimensions();
        this.myList.setExpandableItemsEnabled(false);
        this.myList.setMinimumSize(minCellDimension);
        this.myList.setVisibleRowCount(1);
        this.myList.getEmptyText().setText("Select a capture");
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                Object selectedValue = CellController.this.myList.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                CellController.this.selected((Data)selectedValue);
            }
        });
    }

    protected void populateUi(List<T> cells) {
        this.myData = cells;
        DefaultListModel<Data> model = new DefaultListModel<Data>();
        model.ensureCapacity(this.myData.size());
        for (Data data : this.myData) {
            model.addElement(data);
        }
        this.myList.setModel(model);
        if (this.myData.size() == 0) {
            this.myList.getEmptyText().setText(StatusText.DEFAULT_EMPTY_TEXT);
        }
        this.myList.setCellRenderer((ListCellRenderer)this.myRenderer);
        this.resize(this.myRenderer.getCellDimensions());
    }

    abstract void selected(T var1);

    abstract boolean loadCell(T var1);

    public boolean startLoad(Data cell) {
        return this.loadCell(cell);
    }

    protected void loadCellImage(final Data cell, ServiceClient client, Path imagePath) {
        Futures.addCallback(FetchedImage.load(client, imagePath), (FutureCallback)new LoadingCallback<FetchedImage>(LOG, (LoadingCallback.LoadingDone)cell){

            public void onSuccess(final FetchedImage fetchedImage) {
                EdtExecutor.INSTANCE.execute(new Runnable(){

                    @Override
                    public void run() {
                        cell.icon = fetchedImage.icon;
                        cell.stopLoading();
                        if (CellController.this.myRenderer.updateKnownSize(fetchedImage.dimensions)) {
                            CellController.this.resize(CellController.this.myRenderer.getCellDimensions());
                        }
                        CellController.this.myList.repaint();
                    }
                });
            }
        });
    }

    public void selectItem(int index) {
        this.myList.setSelectedIndex(index);
        this.myList.scrollRectToVisible(this.myList.getCellBounds(index, index));
    }

    @Override
    public void clear() {
        this.myList.setModel(new DefaultListModel());
        this.myList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
    }

    protected void resize(Dimension newDimensions) {
        this.myList.setFixedCellWidth(newDimensions.width);
        this.myList.setFixedCellHeight(newDimensions.height);
        if (this.myList.getLayoutOrientation() == 2) {
            newDimensions.height += this.myScrollPane.getHorizontalScrollBar().getUI().getPreferredSize((JComponent)this.myScrollPane).height;
        } else {
            newDimensions.width += this.myScrollPane.getHorizontalScrollBar().getUI().getPreferredSize((JComponent)this.myScrollPane).width;
        }
        this.myScrollPane.setMinimumSize(newDimensions);
    }

    public static class Data
    implements LoadingCallback.LoadingDone {
        public final String label;
        public ImageIcon icon;
        public long loadstartTime = 0L;
        public boolean isLoading = false;
        public boolean isSelected = false;

        public Data(String label, ImageIcon icon) {
            this.label = label;
            this.icon = icon;
        }

        @Override
        public void stopLoading() {
            this.isLoading = false;
        }

        public boolean isLoaded() {
            return !this.isLoading && this.loadstartTime != 0L;
        }
    }
}

